/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.ticks.LevelTicks;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class ObserverBlock
extends DirectionalBlock {
    public static final MapCodec<ObserverBlock> CODEC = ObserverBlock.simpleCodec(ObserverBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<ObserverBlock> codec() {
        return CODEC;
    }

    public ObserverBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.SOUTH)).setValue(POWERED, false));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, POWERED);
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        return (BlockState)iblockdata.setValue(FACING, enumblockrotation.rotate((Direction)iblockdata.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        return iblockdata.rotate(enumblockmirror.getRotation((Direction)iblockdata.getValue(FACING)));
    }

    @Override
    protected void tick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.getValue(POWERED).booleanValue()) {
            if (CraftEventFactory.callRedstoneChange(worldserver, blockposition, 15, 0).getNewCurrent() != 0) {
                return;
            }
            worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, false), 2);
        } else {
            if (CraftEventFactory.callRedstoneChange(worldserver, blockposition, 0, 15).getNewCurrent() != 15) {
                return;
            }
            worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, true), 2);
            worldserver.scheduleTick(blockposition, this, 2);
        }
        this.updateNeighborsInFront(worldserver, blockposition, iblockdata);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getValue(FACING) == enumdirection && !iblockdata.getValue(POWERED).booleanValue()) {
            this.startSignal(iworldreader, scheduledtickaccess, blockposition);
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    private void startSignal(LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition) {
        if (!iworldreader.isClientSide() && !scheduledtickaccess.getBlockTicks().hasScheduledTick(blockposition, this)) {
            scheduledtickaccess.scheduleTick(blockposition, this, 2);
        }
    }

    protected void updateNeighborsInFront(Level world, BlockPos blockposition, BlockState iblockdata) {
        Direction enumdirection = (Direction)iblockdata.getValue(FACING);
        BlockPos blockposition1 = blockposition.relative(enumdirection.getOpposite());
        Orientation orientation = ExperimentalRedstoneUtils.initialOrientation(world, enumdirection.getOpposite(), null);
        world.neighborChanged(blockposition1, this, orientation);
        world.updateNeighborsAtExceptFromFacing(blockposition1, this, enumdirection, orientation);
    }

    @Override
    protected boolean isSignalSource(BlockState iblockdata) {
        return true;
    }

    @Override
    protected int getDirectSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getSignal(iblockaccess, blockposition, enumdirection);
    }

    @Override
    protected int getSignal(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, Direction enumdirection) {
        return iblockdata.getValue(POWERED) != false && iblockdata.getValue(FACING) == enumdirection ? 15 : 0;
    }

    @Override
    protected void onPlace(BlockState iblockdata, Level world, BlockPos blockposition, BlockState iblockdata1, boolean flag) {
        if (!iblockdata.is(iblockdata1.getBlock()) && !world.isClientSide() && iblockdata.getValue(POWERED).booleanValue() && !world.getBlockTicks().hasScheduledTick(blockposition, this)) {
            BlockState iblockdata2 = (BlockState)iblockdata.setValue(POWERED, false);
            world.setBlock(blockposition, iblockdata2, 18);
            this.updateNeighborsInFront(world, blockposition, iblockdata2);
        }
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, boolean flag) {
        if (iblockdata.getValue(POWERED).booleanValue() && ((LevelTicks)worldserver.getBlockTicks()).hasScheduledTick(blockposition, this)) {
            this.updateNeighborsInFront(worldserver, blockposition, (BlockState)iblockdata.setValue(POWERED, false));
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        return (BlockState)this.defaultBlockState().setValue(FACING, blockactioncontext.getNearestLookingDirection().getOpposite().getOpposite());
    }
}

