/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class PoweredRailBlock
extends BaseRailBlock {
    public static final MapCodec<PoweredRailBlock> CODEC = PoweredRailBlock.simpleCodec(PoweredRailBlock::new);
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.RAIL_SHAPE_STRAIGHT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public MapCodec<PoweredRailBlock> codec() {
        return CODEC;
    }

    protected PoweredRailBlock(BlockBehaviour.Properties blockbase_info) {
        super(true, blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(SHAPE, RailShape.NORTH_SOUTH)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    protected boolean findPoweredRailSignal(Level world, BlockPos blockposition, BlockState iblockdata, boolean flag, int i) {
        if (i >= 8) {
            return false;
        }
        int j = blockposition.getX();
        int k = blockposition.getY();
        int l = blockposition.getZ();
        boolean flag1 = true;
        RailShape blockpropertytrackposition = iblockdata.getValue(SHAPE);
        switch (blockpropertytrackposition) {
            case NORTH_SOUTH: {
                if (flag) {
                    ++l;
                    break;
                }
                --l;
                break;
            }
            case EAST_WEST: {
                if (flag) {
                    --j;
                    break;
                }
                ++j;
                break;
            }
            case ASCENDING_EAST: {
                if (flag) {
                    --j;
                } else {
                    ++j;
                    ++k;
                    flag1 = false;
                }
                blockpropertytrackposition = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_WEST: {
                if (flag) {
                    --j;
                    ++k;
                    flag1 = false;
                } else {
                    ++j;
                }
                blockpropertytrackposition = RailShape.EAST_WEST;
                break;
            }
            case ASCENDING_NORTH: {
                if (flag) {
                    ++l;
                } else {
                    --l;
                    ++k;
                    flag1 = false;
                }
                blockpropertytrackposition = RailShape.NORTH_SOUTH;
                break;
            }
            case ASCENDING_SOUTH: {
                if (flag) {
                    ++l;
                    ++k;
                    flag1 = false;
                } else {
                    --l;
                }
                blockpropertytrackposition = RailShape.NORTH_SOUTH;
            }
        }
        return this.isSameRailWithPower(world, new BlockPos(j, k, l), flag, i, blockpropertytrackposition) ? true : flag1 && this.isSameRailWithPower(world, new BlockPos(j, k - 1, l), flag, i, blockpropertytrackposition);
    }

    protected boolean isSameRailWithPower(Level world, BlockPos blockposition, boolean flag, int i, RailShape blockpropertytrackposition) {
        BlockState iblockdata = world.getBlockState(blockposition);
        if (!iblockdata.is(this)) {
            return false;
        }
        RailShape blockpropertytrackposition1 = iblockdata.getValue(SHAPE);
        return blockpropertytrackposition != RailShape.EAST_WEST || blockpropertytrackposition1 != RailShape.NORTH_SOUTH && blockpropertytrackposition1 != RailShape.ASCENDING_NORTH && blockpropertytrackposition1 != RailShape.ASCENDING_SOUTH ? (blockpropertytrackposition != RailShape.NORTH_SOUTH || blockpropertytrackposition1 != RailShape.EAST_WEST && blockpropertytrackposition1 != RailShape.ASCENDING_EAST && blockpropertytrackposition1 != RailShape.ASCENDING_WEST ? (iblockdata.getValue(POWERED).booleanValue() ? (world.hasNeighborSignal(blockposition) ? true : this.findPoweredRailSignal(world, blockposition, iblockdata, flag, i + 1)) : false) : false) : false;
    }

    @Override
    protected void updateState(BlockState iblockdata, Level world, BlockPos blockposition, Block block) {
        boolean flag1;
        boolean flag = iblockdata.getValue(POWERED);
        boolean bl = flag1 = world.hasNeighborSignal(blockposition) || this.findPoweredRailSignal(world, blockposition, iblockdata, true, 0) || this.findPoweredRailSignal(world, blockposition, iblockdata, false, 0);
        if (flag1 != flag) {
            int power = flag ? 15 : 0;
            int newPower = CraftEventFactory.callRedstoneChange(world, blockposition, power, 15 - power).getNewCurrent();
            if (newPower == power) {
                return;
            }
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, flag1), 3);
            world.updateNeighborsAt(blockposition.below(), this);
            if (iblockdata.getValue(SHAPE).isSlope()) {
                world.updateNeighborsAt(blockposition.above(), this);
            }
        }
    }

    @Override
    public Property<RailShape> getShapeProperty() {
        return SHAPE;
    }

    @Override
    protected BlockState rotate(BlockState iblockdata, Rotation enumblockrotation) {
        RailShape blockpropertytrackposition = iblockdata.getValue(SHAPE);
        RailShape blockpropertytrackposition1 = this.rotate(blockpropertytrackposition, enumblockrotation);
        return (BlockState)iblockdata.setValue(SHAPE, blockpropertytrackposition1);
    }

    @Override
    protected BlockState mirror(BlockState iblockdata, Mirror enumblockmirror) {
        RailShape blockpropertytrackposition = iblockdata.getValue(SHAPE);
        RailShape blockpropertytrackposition1 = this.mirror(blockpropertytrackposition, enumblockmirror);
        return (BlockState)iblockdata.setValue(SHAPE, blockpropertytrackposition1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(SHAPE, POWERED, WATERLOGGED);
    }
}

