/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.BlockHitResult;

public class PumpkinBlock
extends Block {
    public static final MapCodec<PumpkinBlock> CODEC = PumpkinBlock.simpleCodec(PumpkinBlock::new);

    public MapCodec<PumpkinBlock> codec() {
        return CODEC;
    }

    protected PumpkinBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var32, Player var42, InteractionHand var5, BlockHitResult var6) {
        if (!var0.is(Items.SHEARS)) {
            return super.useItemOn(var0, var1, var2, var32, var42, var5, var6);
        }
        if (!(var2 instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel var7 = (ServerLevel)var2;
        Direction var8 = var6.getDirection();
        Direction var9 = var8.getAxis() == Direction.Axis.Y ? var42.getDirection().getOpposite() : var8;
        PumpkinBlock.dropFromBlockInteractLootTable(var7, BuiltInLootTables.CARVE_PUMPKIN, var1, var2.getBlockEntity(var32), var0, var42, (var3, var4) -> {
            ItemEntity var5 = new ItemEntity(var2, (double)var32.getX() + 0.5 + (double)var9.getStepX() * 0.65, (double)var32.getY() + 0.1, (double)var32.getZ() + 0.5 + (double)var9.getStepZ() * 0.65, (ItemStack)var4);
            var5.setDeltaMovement(0.05 * (double)var9.getStepX() + var0.random.nextDouble() * 0.02, 0.05, 0.05 * (double)var9.getStepZ() + var0.random.nextDouble() * 0.02);
            var2.addFreshEntity(var5);
        });
        var2.playSound(null, var32, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
        var2.setBlock(var32, (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState().setValue(CarvedPumpkinBlock.FACING, var9), 11);
        var0.hurtAndBreak(1, (LivingEntity)var42, var5.asEquipmentSlot());
        var2.gameEvent((Entity)var42, GameEvent.SHEAR, var32);
        var42.awardStat(Stats.ITEM_USED.get(Items.SHEARS));
        return InteractionResult.SUCCESS;
    }
}

