/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class RedstoneWallTorchBlock
extends RedstoneTorchBlock {
    public static final MapCodec<RedstoneWallTorchBlock> CODEC = RedstoneWallTorchBlock.simpleCodec(RedstoneWallTorchBlock::new);
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;

    public MapCodec<RedstoneWallTorchBlock> codec() {
        return CODEC;
    }

    protected RedstoneWallTorchBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(LIT, true));
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return WallTorchBlock.getShape(var0);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return WallTorchBlock.canSurvive(var1, var2, var0.getValue(FACING));
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4.getOpposite() == var0.getValue(FACING) && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return var0;
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext var0) {
        BlockState var1 = Blocks.WALL_TORCH.getStateForPlacement(var0);
        return var1 == null ? null : (BlockState)this.defaultBlockState().setValue(FACING, var1.getValue(FACING));
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        if (!var0.getValue(LIT).booleanValue()) {
            return;
        }
        Direction var4 = var0.getValue(FACING).getOpposite();
        double var5 = 0.27;
        double var7 = (double)var2.getX() + 0.5 + (var3.nextDouble() - 0.5) * 0.2 + 0.27 * (double)var4.getStepX();
        double var9 = (double)var2.getY() + 0.7 + (var3.nextDouble() - 0.5) * 0.2 + 0.22;
        double var11 = (double)var2.getZ() + 0.5 + (var3.nextDouble() - 0.5) * 0.2 + 0.27 * (double)var4.getStepZ();
        var1.addParticle(DustParticleOptions.REDSTONE, var7, var9, var11, 0.0, 0.0, 0.0);
    }

    @Override
    protected boolean hasNeighborSignal(Level var0, BlockPos var1, BlockState var2) {
        Direction var3 = var2.getValue(FACING).getOpposite();
        return var0.hasSignal(var1.relative(var3), var3);
    }

    @Override
    protected int getSignal(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        if (var0.getValue(LIT).booleanValue() && var0.getValue(FACING) != var3) {
            return 15;
        }
        return 0;
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, LIT);
    }

    @Override
    protected @Nullable Orientation randomOrientation(Level var0, BlockState var1) {
        return ExperimentalRedstoneUtils.initialOrientation(var0, var1.getValue(FACING).getOpposite(), Direction.UP);
    }
}

