/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.grower.TreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R7.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_21_R7.util.CraftLocation;
import org.bukkit.event.Event;
import org.bukkit.event.world.StructureGrowEvent;

public class SaplingBlock
extends VegetationBlock
implements BonemealableBlock {
    public static final MapCodec<SaplingBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TreeGrower.CODEC.fieldOf("tree").forGetter(blocksapling -> blocksapling.treeGrower), SaplingBlock.propertiesCodec()).apply((Applicative)instance, SaplingBlock::new));
    public static final IntegerProperty STAGE = BlockStateProperties.STAGE;
    private static final VoxelShape SHAPE = Block.column(12.0, 0.0, 12.0);
    protected final TreeGrower treeGrower;
    public static TreeType treeType;

    public MapCodec<? extends SaplingBlock> codec() {
        return CODEC;
    }

    protected SaplingBlock(TreeGrower worldgentreeprovider, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.treeGrower = worldgentreeprovider;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(STAGE, 0));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (worldserver.getMaxLocalRawBrightness(blockposition.above()) >= 9 && randomsource.nextFloat() < (float)worldserver.spigotConfig.saplingModifier / 700.0f) {
            this.advanceTree(worldserver, blockposition, iblockdata, randomsource);
        }
    }

    public void advanceTree(ServerLevel worldserver, BlockPos blockposition, BlockState iblockdata, RandomSource randomsource) {
        if (iblockdata.getValue(STAGE) == 0) {
            worldserver.setBlock(blockposition, (BlockState)iblockdata.cycle(STAGE), 260);
        } else if (worldserver.captureTreeGeneration) {
            this.treeGrower.growTree(worldserver, worldserver.getChunkSource().getGenerator(), blockposition, iblockdata, randomsource);
        } else {
            worldserver.captureTreeGeneration = true;
            this.treeGrower.growTree(worldserver, worldserver.getChunkSource().getGenerator(), blockposition, iblockdata, randomsource);
            worldserver.captureTreeGeneration = false;
            if (worldserver.capturedBlockStates.size() > 0) {
                TreeType treeType = SaplingBlock.treeType;
                SaplingBlock.treeType = null;
                Location location = CraftLocation.toBukkit(blockposition, (World)worldserver.getWorld());
                ArrayList blocks = new ArrayList(worldserver.capturedBlockStates.values());
                worldserver.capturedBlockStates.clear();
                StructureGrowEvent event = null;
                if (treeType != null) {
                    event = new StructureGrowEvent(location, treeType, false, null, blocks);
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event == null || !event.isCancelled()) {
                    for (org.bukkit.block.BlockState blockstate : blocks) {
                        CapturedBlockState.setBlockState(blockstate);
                    }
                }
            }
        }
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return true;
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return (double)world.random.nextFloat() < 0.45;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        this.advanceTree(worldserver, blockposition, iblockdata, randomsource);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(STAGE);
    }
}

