/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.SculkVeinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import org.jspecify.annotations.Nullable;

public interface SculkBehaviour {
    public static final SculkBehaviour DEFAULT = new SculkBehaviour(){

        @Override
        public boolean attemptSpreadVein(LevelAccessor var0, BlockPos var1, BlockState var2, @Nullable Collection<Direction> var3, boolean var4) {
            if (var3 == null) {
                return ((SculkVeinBlock)Blocks.SCULK_VEIN).getSameSpaceSpreader().spreadAll(var0.getBlockState(var1), var0, var1, var4) > 0L;
            }
            if (!var3.isEmpty()) {
                if (var2.isAir() || var2.getFluidState().is(Fluids.WATER)) {
                    return SculkVeinBlock.regrow(var0, var1, var2, var3);
                }
                return false;
            }
            return SculkBehaviour.super.attemptSpreadVein(var0, var1, var2, var3, var4);
        }

        @Override
        public int attemptUseCharge(SculkSpreader.ChargeCursor var0, LevelAccessor var1, BlockPos var2, RandomSource var3, SculkSpreader var4, boolean var5) {
            return var0.getDecayDelay() > 0 ? var0.getCharge() : 0;
        }

        @Override
        public int updateDecayDelay(int var0) {
            return Math.max(var0 - 1, 0);
        }
    };

    default public byte getSculkSpreadDelay() {
        return 1;
    }

    default public void onDischarged(LevelAccessor var0, BlockState var1, BlockPos var2, RandomSource var3) {
    }

    default public boolean depositCharge(LevelAccessor var0, BlockPos var1, RandomSource var2) {
        return false;
    }

    default public boolean attemptSpreadVein(LevelAccessor var0, BlockPos var1, BlockState var2, @Nullable Collection<Direction> var3, boolean var4) {
        return ((MultifaceSpreadeableBlock)Blocks.SCULK_VEIN).getSpreader().spreadAll(var2, var0, var1, var4) > 0L;
    }

    default public boolean canChangeBlockStateOnSpread() {
        return true;
    }

    default public int updateDecayDelay(int var0) {
        return 1;
    }

    public int attemptUseCharge(SculkSpreader.ChargeCursor var1, LevelAccessor var2, BlockPos var3, RandomSource var4, SculkSpreader var5, boolean var6);
}

