/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.block.MultifaceSpreader;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public class SculkVeinBlock
extends MultifaceSpreadeableBlock
implements SculkBehaviour {
    public static final MapCodec<SculkVeinBlock> CODEC = SculkVeinBlock.simpleCodec(SculkVeinBlock::new);
    private final MultifaceSpreader veinSpreader = new MultifaceSpreader(new SculkVeinSpreaderConfig(this, MultifaceSpreader.DEFAULT_SPREAD_ORDER));
    private final MultifaceSpreader sameSpaceSpreader = new MultifaceSpreader(new SculkVeinSpreaderConfig(this, MultifaceSpreader.SpreadType.SAME_POSITION));

    public MapCodec<SculkVeinBlock> codec() {
        return CODEC;
    }

    public SculkVeinBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    @Override
    public MultifaceSpreader getSpreader() {
        return this.veinSpreader;
    }

    public MultifaceSpreader getSameSpaceSpreader() {
        return this.sameSpaceSpreader;
    }

    public static boolean regrow(LevelAccessor generatoraccess, BlockPos blockposition, BlockState iblockdata, Collection<Direction> collection) {
        boolean flag = false;
        BlockState iblockdata1 = Blocks.SCULK_VEIN.defaultBlockState();
        for (Direction enumdirection : collection) {
            if (!SculkVeinBlock.canAttachTo(generatoraccess, blockposition, enumdirection)) continue;
            iblockdata1 = (BlockState)iblockdata1.setValue(SculkVeinBlock.getFaceProperty(enumdirection), true);
            flag = true;
        }
        if (!flag) {
            return false;
        }
        if (!iblockdata.getFluidState().isEmpty()) {
            iblockdata1 = (BlockState)iblockdata1.setValue(MultifaceBlock.WATERLOGGED, true);
        }
        generatoraccess.setBlock(blockposition, iblockdata1, 3);
        return true;
    }

    @Override
    public void onDischarged(LevelAccessor generatoraccess, BlockState iblockdata, BlockPos blockposition, RandomSource randomsource) {
        if (iblockdata.is(this)) {
            for (Direction enumdirection : DIRECTIONS) {
                BooleanProperty blockstateboolean = SculkVeinBlock.getFaceProperty(enumdirection);
                if (!iblockdata.getValue(blockstateboolean).booleanValue() || !generatoraccess.getBlockState(blockposition.relative(enumdirection)).is(Blocks.SCULK)) continue;
                iblockdata = (BlockState)iblockdata.setValue(blockstateboolean, false);
            }
            if (!SculkVeinBlock.hasAnyFace(iblockdata)) {
                FluidState fluid = generatoraccess.getFluidState(blockposition);
                iblockdata = (fluid.isEmpty() ? Blocks.AIR : Blocks.WATER).defaultBlockState();
            }
            generatoraccess.setBlock(blockposition, iblockdata, 3);
            SculkBehaviour.super.onDischarged(generatoraccess, iblockdata, blockposition, randomsource);
        }
    }

    @Override
    public int attemptUseCharge(SculkSpreader.ChargeCursor sculkspreader_a, LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, SculkSpreader sculkspreader, boolean flag) {
        return flag && this.attemptPlaceSculk(sculkspreader, generatoraccess, sculkspreader_a.getPos(), randomsource, blockposition) ? sculkspreader_a.getCharge() - 1 : (randomsource.nextInt(sculkspreader.chargeDecayRate()) == 0 ? Mth.floor((float)sculkspreader_a.getCharge() * 0.5f) : sculkspreader_a.getCharge());
    }

    private boolean attemptPlaceSculk(SculkSpreader sculkspreader, LevelAccessor generatoraccess, BlockPos blockposition, RandomSource randomsource, BlockPos sourceBlock) {
        BlockState iblockdata = generatoraccess.getBlockState(blockposition);
        TagKey<Block> tagkey = sculkspreader.replaceableBlocks();
        for (Direction enumdirection : Direction.allShuffled(randomsource)) {
            BlockPos blockposition1;
            BlockState iblockdata1;
            if (!SculkVeinBlock.hasFace(iblockdata, enumdirection) || !(iblockdata1 = generatoraccess.getBlockState(blockposition1 = blockposition.relative(enumdirection))).is(tagkey)) continue;
            BlockState iblockdata2 = Blocks.SCULK.defaultBlockState();
            if (!CraftEventFactory.handleBlockSpreadEvent(generatoraccess, sourceBlock, blockposition1, iblockdata2, 3)) {
                return false;
            }
            Block.pushEntitiesUp(iblockdata1, iblockdata2, generatoraccess, blockposition1);
            generatoraccess.playSound(null, blockposition1, SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.veinSpreader.spreadAll(iblockdata2, generatoraccess, blockposition1, sculkspreader.isWorldGeneration());
            Direction enumdirection1 = enumdirection.getOpposite();
            for (Direction enumdirection2 : DIRECTIONS) {
                BlockPos blockposition2;
                BlockState iblockdata3;
                if (enumdirection2 == enumdirection1 || !(iblockdata3 = generatoraccess.getBlockState(blockposition2 = blockposition1.relative(enumdirection2))).is(this)) continue;
                this.onDischarged(generatoraccess, iblockdata3, blockposition2, randomsource);
            }
            return true;
        }
        return false;
    }

    public static boolean hasSubstrateAccess(LevelAccessor generatoraccess, BlockState iblockdata, BlockPos blockposition) {
        if (!iblockdata.is(Blocks.SCULK_VEIN)) {
            return false;
        }
        for (Direction enumdirection : DIRECTIONS) {
            if (!SculkVeinBlock.hasFace(iblockdata, enumdirection) || !generatoraccess.getBlockState(blockposition.relative(enumdirection)).is(BlockTags.SCULK_REPLACEABLE)) continue;
            return true;
        }
        return false;
    }

    private class SculkVeinSpreaderConfig
    extends MultifaceSpreader.DefaultSpreaderConfig {
        private final MultifaceSpreader.SpreadType[] spreadTypes;

        public SculkVeinSpreaderConfig(SculkVeinBlock sculkVeinBlock, MultifaceSpreader.SpreadType ... amultifacespreader_e) {
            super(sculkVeinBlock);
            this.spreadTypes = amultifacespreader_e;
        }

        @Override
        public boolean stateCanBeReplaced(BlockGetter iblockaccess, BlockPos blockposition, BlockPos blockposition1, Direction enumdirection, BlockState iblockdata) {
            BlockState iblockdata1 = iblockaccess.getBlockState(blockposition1.relative(enumdirection));
            if (!(iblockdata1.is(Blocks.SCULK) || iblockdata1.is(Blocks.SCULK_CATALYST) || iblockdata1.is(Blocks.MOVING_PISTON))) {
                BlockPos blockposition2;
                if (blockposition.distManhattan(blockposition1) == 2 && iblockaccess.getBlockState(blockposition2 = blockposition.relative(enumdirection.getOpposite())).isFaceSturdy(iblockaccess, blockposition2, enumdirection)) {
                    return false;
                }
                FluidState fluid = iblockdata.getFluidState();
                return !fluid.isEmpty() && !fluid.is(Fluids.WATER) ? false : (iblockdata.is(BlockTags.FIRE) ? false : iblockdata.canBeReplaced() || super.stateCanBeReplaced(iblockaccess, blockposition, blockposition1, enumdirection, iblockdata));
            }
            return false;
        }

        @Override
        public MultifaceSpreader.SpreadType[] getSpreadTypes() {
            return this.spreadTypes;
        }

        @Override
        public boolean isOtherBlockValidAsSource(BlockState iblockdata) {
            return !iblockdata.is(Blocks.SCULK_VEIN);
        }
    }
}

