/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public interface SelectableSlotContainer {
    public int getRows();

    public int getColumns();

    default public OptionalInt getHitSlot(BlockHitResult var02, Direction var1) {
        return SelectableSlotContainer.getRelativeHitCoordinatesForBlockFace(var02, var1).map(var0 -> {
            int var1 = SelectableSlotContainer.getSection(1.0f - var0.y, this.getRows());
            int var2 = SelectableSlotContainer.getSection(var0.x, this.getColumns());
            return OptionalInt.of(var2 + var1 * this.getColumns());
        }).orElseGet(OptionalInt::empty);
    }

    private static Optional<Vec2> getRelativeHitCoordinatesForBlockFace(BlockHitResult var0, Direction var1) {
        Direction var2 = var0.getDirection();
        if (var1 != var2) {
            return Optional.empty();
        }
        BlockPos var3 = var0.getBlockPos().relative(var2);
        Vec3 var4 = var0.getLocation().subtract(var3.getX(), var3.getY(), var3.getZ());
        double var5 = var4.x();
        double var7 = var4.y();
        double var9 = var4.z();
        return switch (var2) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - var5), (float)var7));
            case Direction.SOUTH -> Optional.of(new Vec2((float)var5, (float)var7));
            case Direction.WEST -> Optional.of(new Vec2((float)var9, (float)var7));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - var9), (float)var7));
            case Direction.DOWN, Direction.UP -> Optional.empty();
        };
    }

    public static int getSection(float var0, int var1) {
        float var2 = var0 * 16.0f;
        float var3 = 16.0f / (float)var1;
        return Mth.clamp(Mth.floor(var2 / var3), 0, var1 - 1);
    }
}

