/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SelectableSlotContainer;
import net.minecraft.world.level.block.SideChainPartBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ShelfBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.SideChainPart;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class ShelfBlock
extends BaseEntityBlock
implements SelectableSlotContainer,
SideChainPartBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<ShelfBlock> CODEC = ShelfBlock.simpleCodec(ShelfBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<SideChainPart> SIDE_CHAIN_PART = BlockStateProperties.SIDE_CHAIN_PART;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Shapes.or(Block.box(0.0, 12.0, 11.0, 16.0, 16.0, 13.0), Block.box(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), Block.box(0.0, 0.0, 11.0, 16.0, 4.0, 13.0)));

    public MapCodec<ShelfBlock> codec() {
        return CODEC;
    }

    public ShelfBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(POWERED, false)).setValue(SIDE_CHAIN_PART, SideChainPart.UNCONNECTED)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPES.get(var0.getValue(FACING));
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState var0) {
        return true;
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return var1 == PathComputationType.WATER && var0.getFluidState().is(FluidTags.WATER);
    }

    @Override
    public @Nullable BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new ShelfBlockEntity(var0, var1);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, POWERED, SIDE_CHAIN_PART, WATERLOGGED);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        Containers.updateNeighboursAfterDestroy(var0, var1, var2);
        this.updateNeighborsAfterPoweringDown(var1, var2, var0);
    }

    @Override
    protected void neighborChanged(BlockState var0, Level var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var1.isClientSide()) {
            return;
        }
        boolean var6 = var1.hasNeighborSignal(var2);
        if (var0.getValue(POWERED) != var6) {
            BlockState var7 = (BlockState)var0.setValue(POWERED, var6);
            if (!var6) {
                var7 = (BlockState)var7.setValue(SIDE_CHAIN_PART, SideChainPart.UNCONNECTED);
            }
            var1.setBlock(var2, var7, 3);
            this.playSound(var1, var2, var6 ? SoundEvents.SHELF_ACTIVATE : SoundEvents.SHELF_DEACTIVATE);
            var1.gameEvent(var6 ? GameEvent.BLOCK_ACTIVATE : GameEvent.BLOCK_DEACTIVATE, var2, GameEvent.Context.of(var7));
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        FluidState var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(FACING, var0.getHorizontalDirection().getOpposite())).setValue(POWERED, var0.getLevel().hasNeighborSignal(var0.getClickedPos()))).setValue(WATERLOGGED, var1.getType() == Fluids.WATER);
    }

    @Override
    public BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    public BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    public int getRows() {
        return 1;
    }

    @Override
    public int getColumns() {
        return 3;
    }

    @Override
    protected InteractionResult useItemOn(ItemStack var0, BlockState var1, Level var2, BlockPos var3, Player var4, InteractionHand var5, BlockHitResult var6) {
        ShelfBlockEntity var7;
        block13: {
            block12: {
                BlockEntity blockEntity = var2.getBlockEntity(var3);
                if (!(blockEntity instanceof ShelfBlockEntity)) break block12;
                var7 = (ShelfBlockEntity)blockEntity;
                if (!var5.equals((Object)InteractionHand.OFF_HAND)) break block13;
            }
            return InteractionResult.PASS;
        }
        OptionalInt var8 = this.getHitSlot(var6, var1.getValue(FACING));
        if (var8.isEmpty()) {
            return InteractionResult.PASS;
        }
        Inventory var9 = var4.getInventory();
        if (var2.isClientSide()) {
            return var9.getSelectedItem().isEmpty() ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (!var1.getValue(POWERED).booleanValue()) {
            boolean var10 = ShelfBlock.swapSingleItem(var0, var4, var7, var8.getAsInt(), var9);
            if (var10) {
                this.playSound(var2, var3, var0.isEmpty() ? SoundEvents.SHELF_TAKE_ITEM : SoundEvents.SHELF_SINGLE_SWAP);
            } else if (!var0.isEmpty()) {
                this.playSound(var2, var3, SoundEvents.SHELF_PLACE_ITEM);
            } else {
                return InteractionResult.PASS;
            }
            return InteractionResult.SUCCESS.heldItemTransformedTo(var0);
        }
        ItemStack var10 = var9.getSelectedItem();
        boolean var11 = this.swapHotbar(var2, var3, var9);
        if (!var11) {
            return InteractionResult.CONSUME;
        }
        this.playSound(var2, var3, SoundEvents.SHELF_MULTI_SWAP);
        if (var10 == var9.getSelectedItem()) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS.heldItemTransformedTo(var9.getSelectedItem());
    }

    private static boolean swapSingleItem(ItemStack var0, Player var1, ShelfBlockEntity var2, int var3, Inventory var4) {
        ItemStack var5 = var2.swapItemNoUpdate(var3, var0);
        ItemStack var6 = var1.hasInfiniteMaterials() && var5.isEmpty() ? var0.copy() : var5;
        var4.setItem(var4.getSelectedSlot(), var6);
        var4.setChanged();
        var2.setChanged((Holder.Reference<GameEvent>)(var6.has(DataComponents.USE_EFFECTS) && !var6.get(DataComponents.USE_EFFECTS).interactVibrations() ? null : GameEvent.ITEM_INTERACT_FINISH));
        return !var5.isEmpty();
    }

    private boolean swapHotbar(Level var0, BlockPos var1, Inventory var2) {
        List<BlockPos> var3 = this.getAllBlocksConnectedTo(var0, var1);
        if (var3.isEmpty()) {
            return false;
        }
        boolean var4 = false;
        for (int var5 = 0; var5 < var3.size(); ++var5) {
            ShelfBlockEntity var6 = (ShelfBlockEntity)var0.getBlockEntity(var3.get(var5));
            if (var6 == null) continue;
            for (int var7 = 0; var7 < var6.getContainerSize(); ++var7) {
                int var8 = 9 - (var3.size() - var5) * var6.getContainerSize() + var7;
                if (var8 < 0 || var8 > var2.getContainerSize()) continue;
                ItemStack var9 = var2.removeItemNoUpdate(var8);
                ItemStack var10 = var6.swapItemNoUpdate(var7, var9);
                if (var9.isEmpty() && var10.isEmpty()) continue;
                var2.setItem(var8, var10);
                var4 = true;
            }
            var2.setChanged();
            var6.setChanged(GameEvent.ENTITY_INTERACT);
        }
        return var4;
    }

    @Override
    public SideChainPart getSideChainPart(BlockState var0) {
        return var0.getValue(SIDE_CHAIN_PART);
    }

    @Override
    public BlockState setSideChainPart(BlockState var0, SideChainPart var1) {
        return (BlockState)var0.setValue(SIDE_CHAIN_PART, var1);
    }

    @Override
    public Direction getFacing(BlockState var0) {
        return var0.getValue(FACING);
    }

    @Override
    public boolean isConnectable(BlockState var0) {
        return var0.is(BlockTags.WOODEN_SHELVES) && var0.hasProperty(POWERED) && var0.getValue(POWERED) != false;
    }

    @Override
    public int getMaxChainLength() {
        return 3;
    }

    @Override
    protected void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        if (var0.getValue(POWERED).booleanValue()) {
            this.updateSelfAndNeighborsOnPoweringUp(var1, var2, var0, var3);
        } else {
            this.updateNeighborsAfterPoweringDown(var1, var2, var0);
        }
    }

    private void playSound(LevelAccessor var0, BlockPos var1, SoundEvent var2) {
        var0.playSound(null, var1, var2, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    protected FluidState getFluidState(BlockState var0) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            return Fluids.WATER.getSource(false);
        }
        return super.getFluidState(var0);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var0.getValue(WATERLOGGED).booleanValue()) {
            var2.scheduleTick(var3, Fluids.WATER, Fluids.WATER.getTickDelay(var1));
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState var0) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState var0, Level var1, BlockPos var2, Direction var3) {
        if (var1.isClientSide()) {
            return 0;
        }
        if (var3 != var0.getValue(FACING).getOpposite()) {
            return 0;
        }
        BlockEntity blockEntity = var1.getBlockEntity(var2);
        if (blockEntity instanceof ShelfBlockEntity) {
            ShelfBlockEntity var4 = (ShelfBlockEntity)blockEntity;
            int var5 = var4.getItem(0).isEmpty() ? 0 : 1;
            int var6 = var4.getItem(1).isEmpty() ? 0 : 1;
            int var7 = var4.getItem(2).isEmpty() ? 0 : 1;
            return var5 | var6 << 1 | var7 << 2;
        }
        return 0;
    }
}

