/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SignApplicator;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.event.player.PlayerSignOpenEvent;
import org.jspecify.annotations.Nullable;

public abstract class SignBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Block.column(8.0, 0.0, 16.0);
    private final WoodType type;

    protected SignBlock(WoodType blockpropertywood, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.type = blockpropertywood;
    }

    protected abstract MapCodec<? extends SignBlock> codec();

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPE;
    }

    @Override
    public boolean isPossibleToRespawnInThis(BlockState iblockdata) {
        return true;
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        return new SignBlockEntity(blockposition, iblockdata);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof SignBlockEntity) {
            boolean flag;
            SignApplicator signapplicator1;
            SignBlockEntity tileentitysign = (SignBlockEntity)tileentity;
            Item item = itemstack.getItem();
            SignApplicator signapplicator = item instanceof SignApplicator ? (signapplicator1 = (SignApplicator)((Object)item)) : null;
            SignApplicator signapplicator2 = signapplicator;
            boolean bl = flag = signapplicator2 != null && entityhuman.mayBuild();
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (flag && !tileentitysign.isWaxed() && !this.otherPlayerIsEditingSign(entityhuman, tileentitysign)) {
                    boolean flag1 = tileentitysign.isFacingFrontText(entityhuman);
                    if (signapplicator2.canApplyToSign(tileentitysign.getText(flag1), entityhuman) && signapplicator2.tryApplyToSign(worldserver, tileentitysign, flag1, entityhuman)) {
                        tileentitysign.executeClickCommandsIfPresent(worldserver, entityhuman, blockposition, flag1);
                        entityhuman.awardStat(Stats.ITEM_USED.get(itemstack.getItem()));
                        worldserver.gameEvent(GameEvent.BLOCK_CHANGE, tileentitysign.getBlockPos(), GameEvent.Context.of(entityhuman, tileentitysign.getBlockState()));
                        itemstack.consume(1, entityhuman);
                        return InteractionResult.SUCCESS;
                    }
                    return InteractionResult.TRY_WITH_EMPTY_HAND;
                }
                return InteractionResult.TRY_WITH_EMPTY_HAND;
            }
            return !flag && !tileentitysign.isWaxed() ? InteractionResult.CONSUME : InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        BlockEntity tileentity = world.getBlockEntity(blockposition);
        if (tileentity instanceof SignBlockEntity) {
            SignBlockEntity tileentitysign = (SignBlockEntity)tileentity;
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                boolean flag = tileentitysign.isFacingFrontText(entityhuman);
                boolean flag1 = tileentitysign.executeClickCommandsIfPresent(worldserver, entityhuman, blockposition, flag);
                if (tileentitysign.isWaxed()) {
                    worldserver.playSound(null, tileentitysign.getBlockPos(), tileentitysign.getSignInteractionFailedSoundEvent(), SoundSource.BLOCKS);
                    return InteractionResult.SUCCESS_SERVER;
                }
                if (flag1) {
                    return InteractionResult.SUCCESS_SERVER;
                }
                if (!this.otherPlayerIsEditingSign(entityhuman, tileentitysign) && entityhuman.mayBuild() && this.hasEditableText(entityhuman, tileentitysign, flag)) {
                    this.openTextEdit(entityhuman, tileentitysign, flag, PlayerSignOpenEvent.Cause.INTERACT);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.PASS;
            }
            Util.pauseInIde(new IllegalStateException("Expected to only call this on server"));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    private boolean hasEditableText(Player entityhuman, SignBlockEntity tileentitysign, boolean flag) {
        SignText signtext = tileentitysign.getText(flag);
        return Arrays.stream(signtext.getMessages(entityhuman.isTextFilteringEnabled())).allMatch(ichatbasecomponent -> ichatbasecomponent.equals(CommonComponents.EMPTY) || ichatbasecomponent.getContents() instanceof PlainTextContents);
    }

    public abstract float getYRotationDegrees(BlockState var1);

    public Vec3 getSignHitboxCenterPosition(BlockState iblockdata) {
        return new Vec3(0.5, 0.5, 0.5);
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    public WoodType type() {
        return this.type;
    }

    public static WoodType getWoodType(Block block) {
        WoodType blockpropertywood = block instanceof SignBlock ? ((SignBlock)block).type() : WoodType.OAK;
        return blockpropertywood;
    }

    public void openTextEdit(Player entityhuman, SignBlockEntity tileentitysign, boolean flag) {
        this.openTextEdit(entityhuman, tileentitysign, flag, PlayerSignOpenEvent.Cause.UNKNOWN);
    }

    public void openTextEdit(Player entityhuman, SignBlockEntity tileentitysign, boolean flag, PlayerSignOpenEvent.Cause cause) {
        if (!CraftEventFactory.callPlayerSignOpenEvent(entityhuman, tileentitysign, flag, cause)) {
            return;
        }
        tileentitysign.setAllowedPlayerEditor(entityhuman.getUUID());
        entityhuman.openTextEdit(tileentitysign, flag);
    }

    private boolean otherPlayerIsEditingSign(Player entityhuman, SignBlockEntity tileentitysign) {
        UUID uuid = tileentitysign.getPlayerWhoMayEdit();
        return uuid != null && !uuid.equals(entityhuman.getUUID());
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level world, BlockState iblockdata, BlockEntityType<T> tileentitytypes) {
        return null;
    }
}

