/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jspecify.annotations.Nullable;

public class SmokerBlock
extends AbstractFurnaceBlock {
    public static final MapCodec<SmokerBlock> CODEC = SmokerBlock.simpleCodec(SmokerBlock::new);

    public MapCodec<SmokerBlock> codec() {
        return CODEC;
    }

    protected SmokerBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new SmokerBlockEntity(var0, var1);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level var0, BlockState var1, BlockEntityType<T> var2) {
        return SmokerBlock.createFurnaceTicker(var0, var2, BlockEntityType.SMOKER);
    }

    @Override
    protected void openContainer(Level var0, BlockPos var1, Player var2) {
        BlockEntity var3 = var0.getBlockEntity(var1);
        if (var3 instanceof SmokerBlockEntity) {
            var2.openMenu((MenuProvider)((Object)var3));
            var2.awardStat(Stats.INTERACT_WITH_SMOKER);
        }
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        if (!var0.getValue(LIT).booleanValue()) {
            return;
        }
        double var4 = (double)var2.getX() + 0.5;
        double var6 = var2.getY();
        double var8 = (double)var2.getZ() + 0.5;
        if (var3.nextDouble() < 0.1) {
            var1.playLocalSound(var4, var6, var8, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
        var1.addParticle(ParticleTypes.SMOKE, var4, var6 + 1.1, var8, 0.0, 0.0, 0.0);
    }
}

