/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BubbleColumnBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SoulSandBlock
extends Block {
    public static final MapCodec<SoulSandBlock> CODEC = SoulSandBlock.simpleCodec(SoulSandBlock::new);
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 14.0);
    private static final int BUBBLE_COLUMN_CHECK_DELAY = 20;

    public MapCodec<SoulSandBlock> codec() {
        return CODEC;
    }

    public SoulSandBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return SHAPE;
    }

    @Override
    protected VoxelShape getBlockSupportShape(BlockState var0, BlockGetter var1, BlockPos var2) {
        return Shapes.block();
    }

    @Override
    protected VoxelShape getVisualShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return Shapes.block();
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        BubbleColumnBlock.updateColumn(var1, var2.above(), var0);
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4 == Direction.UP && var6.is(Blocks.WATER)) {
            var2.scheduleTick(var3, this, 20);
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        var1.scheduleTick(var2, this, 20);
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }

    @Override
    protected float getShadeBrightness(BlockState var0, BlockGetter var1, BlockPos var2) {
        return 0.2f;
    }
}

