/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LightEngine;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;

public abstract class SpreadingSnowyDirtBlock
extends SnowyDirtBlock {
    protected SpreadingSnowyDirtBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
    }

    private static boolean canBeGrass(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.above();
        BlockState iblockdata1 = iworldreader.getBlockState(blockposition1);
        if (iblockdata1.is(Blocks.SNOW) && iblockdata1.getValue(SnowLayerBlock.LAYERS) == 1) {
            return true;
        }
        if (iblockdata1.getFluidState().getAmount() == 8) {
            return false;
        }
        int i = LightEngine.getLightBlockInto(iblockdata, iblockdata1, Direction.UP, iblockdata1.getLightBlock());
        return i < 15;
    }

    protected abstract MapCodec<? extends SpreadingSnowyDirtBlock> codec();

    private static boolean canPropagate(BlockState iblockdata, LevelReader iworldreader, BlockPos blockposition) {
        BlockPos blockposition1 = blockposition.above();
        return SpreadingSnowyDirtBlock.canBeGrass(iblockdata, iworldreader, blockposition) && !iworldreader.getFluidState(blockposition1).is(FluidTags.WATER);
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        if (!SpreadingSnowyDirtBlock.canBeGrass(iblockdata, worldserver, blockposition)) {
            if (CraftEventFactory.callBlockFadeEvent(worldserver, blockposition, Blocks.DIRT.defaultBlockState()).isCancelled()) {
                return;
            }
            worldserver.setBlockAndUpdate(blockposition, Blocks.DIRT.defaultBlockState());
        } else if (worldserver.getMaxLocalRawBrightness(blockposition.above()) >= 9) {
            BlockState iblockdata1 = this.defaultBlockState();
            for (int i = 0; i < 4; ++i) {
                BlockPos blockposition1 = blockposition.offset(randomsource.nextInt(3) - 1, randomsource.nextInt(5) - 3, randomsource.nextInt(3) - 1);
                if (!worldserver.getBlockState(blockposition1).is(Blocks.DIRT) || !SpreadingSnowyDirtBlock.canPropagate(iblockdata1, worldserver, blockposition1)) continue;
                CraftEventFactory.handleBlockSpreadEvent(worldserver, blockposition, blockposition1, (BlockState)iblockdata1.setValue(SNOWY, SpreadingSnowyDirtBlock.isSnowySetting(worldserver.getBlockState(blockposition1.above()))));
            }
        }
    }
}

