/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jspecify.annotations.Nullable;

public class StructureBlock
extends BaseEntityBlock
implements GameMasterBlock {
    public static final MapCodec<StructureBlock> CODEC = StructureBlock.simpleCodec(StructureBlock::new);
    public static final EnumProperty<StructureMode> MODE = BlockStateProperties.STRUCTUREBLOCK_MODE;

    public MapCodec<StructureBlock> codec() {
        return CODEC;
    }

    protected StructureBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(MODE, StructureMode.LOAD));
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new StructureBlockEntity(var0, var1);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        BlockEntity var5 = var1.getBlockEntity(var2);
        if (var5 instanceof StructureBlockEntity) {
            return ((StructureBlockEntity)var5).usedBy(var3) ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public void setPlacedBy(Level var0, BlockPos var1, BlockState var2, @Nullable LivingEntity var3, ItemStack var4) {
        BlockEntity var5;
        if (var0.isClientSide()) {
            return;
        }
        if (var3 != null && (var5 = var0.getBlockEntity(var1)) instanceof StructureBlockEntity) {
            ((StructureBlockEntity)var5).createdBy(var3);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(MODE);
    }

    @Override
    protected void neighborChanged(BlockState var0, Level var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (!(var1 instanceof ServerLevel)) {
            return;
        }
        BlockEntity var6 = var1.getBlockEntity(var2);
        if (!(var6 instanceof StructureBlockEntity)) {
            return;
        }
        StructureBlockEntity var7 = (StructureBlockEntity)var6;
        boolean var8 = var1.hasNeighborSignal(var2);
        boolean var9 = var7.isPowered();
        if (var8 && !var9) {
            var7.setPowered(true);
            this.trigger((ServerLevel)var1, var7);
        } else if (!var8 && var9) {
            var7.setPowered(false);
        }
    }

    private void trigger(ServerLevel var0, StructureBlockEntity var1) {
        switch (var1.getMode()) {
            case SAVE: {
                var1.saveStructure(false);
                break;
            }
            case LOAD: {
                var1.placeStructure(var0);
                break;
            }
            case CORNER: {
                var1.unloadStructure();
                break;
            }
            case DATA: {
                break;
            }
        }
    }
}

