/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.ItemLike;
import org.jspecify.annotations.Nullable;

public interface SuspiciousEffectHolder {
    public SuspiciousStewEffects getSuspiciousEffects();

    public static List<SuspiciousEffectHolder> getAllEffectHolders() {
        return BuiltInRegistries.ITEM.stream().map(SuspiciousEffectHolder::tryGet).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static @Nullable SuspiciousEffectHolder tryGet(ItemLike var0) {
        Object var1;
        FeatureElement featureElement = var0.asItem();
        if (featureElement instanceof BlockItem && (featureElement = ((BlockItem)(var1 = (BlockItem)featureElement)).getBlock()) instanceof SuspiciousEffectHolder) {
            SuspiciousEffectHolder var2 = (SuspiciousEffectHolder)((Object)featureElement);
            return var2;
        }
        Item item = var0.asItem();
        if (item instanceof SuspiciousEffectHolder) {
            var1 = (SuspiciousEffectHolder)((Object)item);
            return var1;
        }
        return null;
    }
}

