/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.VegetationBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R7.inventory.CraftItemStack;
import org.bukkit.event.player.PlayerHarvestBlockEvent;
import org.bukkit.inventory.ItemStack;

public class SweetBerryBushBlock
extends VegetationBlock
implements BonemealableBlock {
    public static final MapCodec<SweetBerryBushBlock> CODEC = SweetBerryBushBlock.simpleCodec(SweetBerryBushBlock::new);
    private static final float HURT_SPEED_THRESHOLD = 0.003f;
    public static final int MAX_AGE = 3;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_3;
    private static final VoxelShape SHAPE_SAPLING = Block.column(10.0, 0.0, 8.0);
    private static final VoxelShape SHAPE_GROWING = Block.column(14.0, 0.0, 16.0);

    public MapCodec<SweetBerryBushBlock> codec() {
        return CODEC;
    }

    public SweetBerryBushBlock(BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(AGE, 0));
    }

    @Override
    protected net.minecraft.world.item.ItemStack getCloneItemStack(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata, boolean flag) {
        return new net.minecraft.world.item.ItemStack(Items.SWEET_BERRIES);
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return switch (iblockdata.getValue(AGE)) {
            case 0 -> SHAPE_SAPLING;
            case 3 -> Shapes.block();
            default -> SHAPE_GROWING;
        };
    }

    @Override
    protected boolean isRandomlyTicking(BlockState iblockdata) {
        return iblockdata.getValue(AGE) < 3;
    }

    @Override
    protected void randomTick(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource) {
        int i = iblockdata.getValue(AGE);
        if (i < 3 && randomsource.nextFloat() < (float)worldserver.spigotConfig.sweetBerryModifier / 500.0f && worldserver.getRawBrightness(blockposition.above(), 0) >= 9) {
            BlockState iblockdata1 = (BlockState)iblockdata.setValue(AGE, i + 1);
            if (!CraftEventFactory.handleBlockGrowEvent(worldserver, blockposition, iblockdata1, 2)) {
                return;
            }
            worldserver.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(iblockdata1));
        }
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (entity instanceof LivingEntity && entity.getType() != EntityType.FOX && entity.getType() != EntityType.BEE) {
            entity.makeStuckInBlock(iblockdata, new Vec3(0.8f, 0.75, 0.8f));
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                if (iblockdata.getValue(AGE) != 0) {
                    Vec3 vec3d;
                    Vec3 vec3 = vec3d = entity.isClientAuthoritative() ? entity.getKnownMovement() : entity.oldPosition().subtract(entity.position());
                    if (vec3d.horizontalDistanceSqr() > 0.0) {
                        double d0 = Math.abs(vec3d.x());
                        double d1 = Math.abs(vec3d.z());
                        if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                            entity.hurtServer(worldserver, world.damageSources().sweetBerryBush().directBlock(world, blockposition), 1.0f);
                        }
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected InteractionResult useItemOn(net.minecraft.world.item.ItemStack itemstack, BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, InteractionHand enumhand, BlockHitResult movingobjectpositionblock) {
        int i = iblockdata.getValue(AGE);
        boolean flag = i == 3;
        return !flag && itemstack.is(Items.BONE_MEAL) ? InteractionResult.PASS : super.useItemOn(itemstack, iblockdata, world, blockposition, entityhuman, enumhand, movingobjectpositionblock);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (iblockdata.getValue(AGE) > 1) {
            if (world instanceof ServerLevel) {
                ServerLevel worldserver = (ServerLevel)world;
                LinkedList<net.minecraft.world.item.ItemStack> dropped = new LinkedList<net.minecraft.world.item.ItemStack>();
                Block.dropFromBlockInteractLootTable(worldserver, BuiltInLootTables.HARVEST_SWEET_BERRY_BUSH, iblockdata, world.getBlockEntity(blockposition), null, entityhuman, (worldserver1, itemstack) -> dropped.add((net.minecraft.world.item.ItemStack)itemstack));
                PlayerHarvestBlockEvent event = CraftEventFactory.callPlayerHarvestBlockEvent(world, blockposition, entityhuman, InteractionHand.MAIN_HAND, dropped);
                if (event.isCancelled()) {
                    return InteractionResult.SUCCESS;
                }
                for (ItemStack itemStack : event.getItemsHarvested()) {
                    SweetBerryBushBlock.popResource(world, blockposition, CraftItemStack.asNMSCopy(itemStack));
                }
                worldserver.playSound((Entity)null, blockposition, SoundEvents.SWEET_BERRY_BUSH_PICK_BERRIES, SoundSource.BLOCKS, 1.0f, 0.8f + worldserver.random.nextFloat() * 0.4f);
                BlockState iblockdata1 = (BlockState)iblockdata.setValue(AGE, 1);
                worldserver.setBlock(blockposition, iblockdata1, 2);
                worldserver.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entityhuman, iblockdata1));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(iblockdata, world, blockposition, entityhuman, movingobjectpositionblock);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(AGE);
    }

    @Override
    public boolean isValidBonemealTarget(LevelReader iworldreader, BlockPos blockposition, BlockState iblockdata) {
        return iblockdata.getValue(AGE) < 3;
    }

    @Override
    public boolean isBonemealSuccess(Level world, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        return true;
    }

    @Override
    public void performBonemeal(ServerLevel worldserver, RandomSource randomsource, BlockPos blockposition, BlockState iblockdata) {
        int i = Math.min(3, iblockdata.getValue(AGE) + 1);
        worldserver.setBlock(blockposition, (BlockState)iblockdata.setValue(AGE, i), 2);
    }
}

