/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.arrow.AbstractArrow;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class TargetBlock
extends Block {
    public static final MapCodec<TargetBlock> CODEC = TargetBlock.simpleCodec(TargetBlock::new);
    private static final IntegerProperty OUTPUT_POWER = BlockStateProperties.POWER;
    private static final int ACTIVATION_TICKS_ARROWS = 20;
    private static final int ACTIVATION_TICKS_OTHER = 8;

    public MapCodec<TargetBlock> codec() {
        return CODEC;
    }

    public TargetBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(OUTPUT_POWER, 0));
    }

    @Override
    protected void onProjectileHit(Level var0, BlockState var1, BlockHitResult var2, Projectile var3) {
        int var4 = TargetBlock.updateRedstoneOutput(var0, var1, var2, var3);
        Entity var5 = var3.getOwner();
        if (var5 instanceof ServerPlayer) {
            ServerPlayer var6 = (ServerPlayer)var5;
            var6.awardStat(Stats.TARGET_HIT);
            CriteriaTriggers.TARGET_BLOCK_HIT.trigger(var6, var3, var2.getLocation(), var4);
        }
    }

    private static int updateRedstoneOutput(LevelAccessor var0, BlockState var1, BlockHitResult var2, Entity var3) {
        int var5;
        int var4 = TargetBlock.getRedstoneStrength(var2, var2.getLocation());
        int n = var5 = var3 instanceof AbstractArrow ? 20 : 8;
        if (!var0.getBlockTicks().hasScheduledTick(var2.getBlockPos(), var1.getBlock())) {
            TargetBlock.setOutputPower(var0, var1, var4, var2.getBlockPos(), var5);
        }
        return var4;
    }

    private static int getRedstoneStrength(BlockHitResult var0, Vec3 var1) {
        Direction var2 = var0.getDirection();
        double var3 = Math.abs(Mth.frac(var1.x) - 0.5);
        double var5 = Math.abs(Mth.frac(var1.y) - 0.5);
        double var7 = Math.abs(Mth.frac(var1.z) - 0.5);
        Direction.Axis var11 = var2.getAxis();
        double var9 = var11 == Direction.Axis.Y ? Math.max(var3, var7) : (var11 == Direction.Axis.Z ? Math.max(var3, var5) : Math.max(var5, var7));
        return Math.max(1, Mth.ceil(15.0 * Mth.clamp((0.5 - var9) / 0.5, 0.0, 1.0)));
    }

    private static void setOutputPower(LevelAccessor var0, BlockState var1, int var2, BlockPos var3, int var4) {
        var0.setBlock(var3, (BlockState)var1.setValue(OUTPUT_POWER, var2), 3);
        var0.scheduleTick(var3, var1.getBlock(), var4);
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        if (var0.getValue(OUTPUT_POWER) != 0) {
            var1.setBlock(var2, (BlockState)var0.setValue(OUTPUT_POWER, 0), 3);
        }
    }

    @Override
    protected int getSignal(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        return var0.getValue(OUTPUT_POWER);
    }

    @Override
    protected boolean isSignalSource(BlockState var0) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(OUTPUT_POWER);
    }

    @Override
    protected void onPlace(BlockState var0, Level var1, BlockPos var2, BlockState var3, boolean var4) {
        if (var1.isClientSide() || var0.is(var3.getBlock())) {
            return;
        }
        if (var0.getValue(OUTPUT_POWER) > 0 && !var1.getBlockTicks().hasScheduledTick(var2, this)) {
            var1.setBlock(var2, (BlockState)var0.setValue(OUTPUT_POWER, 0), 18);
        }
    }
}

