/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.TestBlockMode;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import org.jspecify.annotations.Nullable;

public class TestBlock
extends BaseEntityBlock
implements GameMasterBlock {
    public static final MapCodec<TestBlock> CODEC = TestBlock.simpleCodec(TestBlock::new);
    public static final EnumProperty<TestBlockMode> MODE = BlockStateProperties.TEST_BLOCK_MODE;

    public TestBlock(BlockBehaviour.Properties var0) {
        super(var0);
    }

    @Override
    public @Nullable BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return new TestBlockEntity(var0, var1);
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext var0) {
        TestBlockMode var3;
        BlockItemStateProperties var1 = var0.getItemInHand().get(DataComponents.BLOCK_STATE);
        BlockState var2 = this.defaultBlockState();
        if (var1 != null && (var3 = var1.get(MODE)) != null) {
            var2 = (BlockState)var2.setValue(MODE, var3);
        }
        return var2;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(MODE);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        BlockEntity var5 = var1.getBlockEntity(var2);
        if (!(var5 instanceof TestBlockEntity)) {
            return InteractionResult.PASS;
        }
        TestBlockEntity var6 = (TestBlockEntity)var5;
        if (!var3.canUseGameMasterBlocks()) {
            return InteractionResult.PASS;
        }
        if (var1.isClientSide()) {
            var3.openTestBlock(var6);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void tick(BlockState var0, ServerLevel var1, BlockPos var2, RandomSource var3) {
        TestBlockEntity var4 = TestBlock.getServerTestBlockEntity(var1, var2);
        if (var4 == null) {
            return;
        }
        var4.reset();
    }

    @Override
    protected void neighborChanged(BlockState var0, Level var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5) {
        TestBlockEntity var6 = TestBlock.getServerTestBlockEntity(var1, var2);
        if (var6 == null) {
            return;
        }
        if (var6.getMode() == TestBlockMode.START) {
            return;
        }
        boolean var7 = var1.hasNeighborSignal(var2);
        boolean var8 = var6.isPowered();
        if (var7 && !var8) {
            var6.setPowered(true);
            var6.trigger();
        } else if (!var7 && var8) {
            var6.setPowered(false);
        }
    }

    private static @Nullable TestBlockEntity getServerTestBlockEntity(Level var0, BlockPos var1) {
        ServerLevel var2;
        BlockEntity blockEntity;
        if (var0 instanceof ServerLevel && (blockEntity = (var2 = (ServerLevel)var0).getBlockEntity(var1)) instanceof TestBlockEntity) {
            TestBlockEntity var3 = (TestBlockEntity)blockEntity;
            return var3;
        }
        return null;
    }

    @Override
    public int getSignal(BlockState var0, BlockGetter var1, BlockPos var2, Direction var3) {
        if (var0.getValue(MODE) != TestBlockMode.START) {
            return 0;
        }
        BlockEntity var4 = var1.getBlockEntity(var2);
        if (var4 instanceof TestBlockEntity) {
            TestBlockEntity var5 = (TestBlockEntity)var4;
            return var5.isPowered() ? 15 : 0;
        }
        return 0;
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader var0, BlockPos var1, BlockState var2, boolean var3) {
        ItemStack var4 = super.getCloneItemStack(var0, var1, var2, var3);
        return TestBlock.setModeOnStack(var4, var2.getValue(MODE));
    }

    public static ItemStack setModeOnStack(ItemStack var0, TestBlockMode var1) {
        var0.set(DataComponents.BLOCK_STATE, var0.getOrDefault(DataComponents.BLOCK_STATE, BlockItemStateProperties.EMPTY).with(MODE, var1));
        return var0;
    }

    protected MapCodec<TestBlock> codec() {
        return CODEC;
    }
}

