/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.craftbukkit.v1_21_R7.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.jspecify.annotations.Nullable;

public class TrapDoorBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<TrapDoorBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(blocktrapdoor -> blocktrapdoor.type), TrapDoorBlock.propertiesCodec()).apply((Applicative)instance, TrapDoorBlock::new));
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<Half> HALF = BlockStateProperties.HALF;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateAll(Block.boxZ(16.0, 13.0, 16.0));
    private final BlockSetType type;

    public MapCodec<? extends TrapDoorBlock> codec() {
        return CODEC;
    }

    protected TrapDoorBlock(BlockSetType blocksettype, BlockBehaviour.Properties blockbase_info) {
        super(blockbase_info.sound(blocksettype.soundType()));
        this.type = blocksettype;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(OPEN, false)).setValue(HALF, Half.BOTTOM)).setValue(POWERED, false)).setValue(WATERLOGGED, false));
    }

    @Override
    protected VoxelShape getShape(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition, CollisionContext voxelshapecollision) {
        return SHAPES.get(iblockdata.getValue(OPEN) != false ? iblockdata.getValue(FACING) : (iblockdata.getValue(HALF) == Half.TOP ? Direction.DOWN : Direction.UP));
    }

    @Override
    protected boolean isPathfindable(BlockState iblockdata, PathComputationType pathmode) {
        switch (pathmode) {
            case LAND: {
                return iblockdata.getValue(OPEN);
            }
            case WATER: {
                return iblockdata.getValue(WATERLOGGED);
            }
            case AIR: {
                return iblockdata.getValue(OPEN);
            }
        }
        return false;
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState iblockdata, Level world, BlockPos blockposition, Player entityhuman, BlockHitResult movingobjectpositionblock) {
        if (!this.type.canOpenByHand()) {
            return InteractionResult.PASS;
        }
        this.toggle(iblockdata, world, blockposition, entityhuman);
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void onExplosionHit(BlockState iblockdata, ServerLevel worldserver, BlockPos blockposition, Explosion explosion, BiConsumer<ItemStack, BlockPos> biconsumer) {
        if (explosion.canTriggerBlocks() && this.type.canOpenByWindCharge() && !iblockdata.getValue(POWERED).booleanValue()) {
            this.toggle(iblockdata, worldserver, blockposition, null);
        }
        super.onExplosionHit(iblockdata, worldserver, blockposition, explosion, biconsumer);
    }

    private void toggle(BlockState iblockdata, Level world, BlockPos blockposition, @Nullable Player entityhuman) {
        BlockState iblockdata1 = (BlockState)iblockdata.cycle(OPEN);
        world.setBlock(blockposition, iblockdata1, 2);
        if (iblockdata1.getValue(WATERLOGGED).booleanValue()) {
            world.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(world));
        }
        this.playSound(entityhuman, world, blockposition, iblockdata1.getValue(OPEN));
    }

    protected void playSound(@Nullable Player entityhuman, Level world, BlockPos blockposition, boolean flag) {
        world.playSound((Entity)entityhuman, blockposition, flag ? this.type.trapdoorOpen() : this.type.trapdoorClose(), SoundSource.BLOCKS, 1.0f, world.getRandom().nextFloat() * 0.1f + 0.9f);
        world.gameEvent((Entity)entityhuman, flag ? GameEvent.BLOCK_OPEN : GameEvent.BLOCK_CLOSE, blockposition);
    }

    @Override
    protected void neighborChanged(BlockState iblockdata, Level world, BlockPos blockposition, Block block, @Nullable Orientation orientation, boolean flag) {
        boolean flag1;
        if (!world.isClientSide() && (flag1 = world.hasNeighborSignal(blockposition)) != iblockdata.getValue(POWERED)) {
            CraftWorld bworld = world.getWorld();
            org.bukkit.block.Block bblock = bworld.getBlockAt(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            int power = bblock.getBlockPower();
            int oldPower = iblockdata.getValue(OPEN) != false ? 15 : 0;
            if (oldPower == 0 ^ power == 0 || block.defaultBlockState().isSignalSource()) {
                BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent(bblock, oldPower, power);
                world.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
                boolean bl = flag1 = eventRedstone.getNewCurrent() > 0;
            }
            if (iblockdata.getValue(OPEN) != flag1) {
                iblockdata = (BlockState)iblockdata.setValue(OPEN, flag1);
                this.playSound(null, world, blockposition, flag1);
            }
            world.setBlock(blockposition, (BlockState)iblockdata.setValue(POWERED, flag1), 2);
            if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
                world.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(world));
            }
        }
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext blockactioncontext) {
        BlockState iblockdata = this.defaultBlockState();
        FluidState fluid = blockactioncontext.getLevel().getFluidState(blockactioncontext.getClickedPos());
        Direction enumdirection = blockactioncontext.getClickedFace();
        iblockdata = !blockactioncontext.replacingClickedOnBlock() && enumdirection.getAxis().isHorizontal() ? (BlockState)((BlockState)iblockdata.setValue(FACING, enumdirection)).setValue(HALF, blockactioncontext.getClickLocation().y - (double)blockactioncontext.getClickedPos().getY() > 0.5 ? Half.TOP : Half.BOTTOM) : (BlockState)((BlockState)iblockdata.setValue(FACING, blockactioncontext.getHorizontalDirection().getOpposite())).setValue(HALF, enumdirection == Direction.UP ? Half.BOTTOM : Half.TOP);
        if (blockactioncontext.getLevel().hasNeighborSignal(blockactioncontext.getClickedPos())) {
            iblockdata = (BlockState)((BlockState)iblockdata.setValue(OPEN, true)).setValue(POWERED, true);
        }
        return (BlockState)iblockdata.setValue(WATERLOGGED, fluid.getType() == Fluids.WATER);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockstatelist_a) {
        blockstatelist_a.add(FACING, OPEN, HALF, POWERED, WATERLOGGED);
    }

    @Override
    protected FluidState getFluidState(BlockState iblockdata) {
        return iblockdata.getValue(WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(iblockdata);
    }

    @Override
    protected BlockState updateShape(BlockState iblockdata, LevelReader iworldreader, ScheduledTickAccess scheduledtickaccess, BlockPos blockposition, Direction enumdirection, BlockPos blockposition1, BlockState iblockdata1, RandomSource randomsource) {
        if (iblockdata.getValue(WATERLOGGED).booleanValue()) {
            scheduledtickaccess.scheduleTick(blockposition, Fluids.WATER, Fluids.WATER.getTickDelay(iworldreader));
        }
        return super.updateShape(iblockdata, iworldreader, scheduledtickaccess, blockposition, enumdirection, blockposition1, iblockdata1, randomsource);
    }

    protected BlockSetType getType() {
        return this.type;
    }
}

