/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class WallTorchBlock
extends TorchBlock {
    public static final MapCodec<WallTorchBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)PARTICLE_OPTIONS_FIELD.forGetter(var0 -> var0.flameParticle), WallTorchBlock.propertiesCodec()).apply((Applicative)var02, WallTorchBlock::new));
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateHorizontal(Block.boxZ(5.0, 3.0, 13.0, 11.0, 16.0));

    public MapCodec<WallTorchBlock> codec() {
        return CODEC;
    }

    protected WallTorchBlock(SimpleParticleType var0, BlockBehaviour.Properties var1) {
        super(var0, var1);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH));
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return WallTorchBlock.getShape(var0);
    }

    public static VoxelShape getShape(BlockState var0) {
        return SHAPES.get(var0.getValue(FACING));
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        return WallTorchBlock.canSurvive(var1, var2, var0.getValue(FACING));
    }

    public static boolean canSurvive(LevelReader var0, BlockPos var1, Direction var2) {
        BlockPos var3 = var1.relative(var2.getOpposite());
        BlockState var4 = var0.getBlockState(var3);
        return var4.isFaceSturdy(var0, var3, var2);
    }

    @Override
    public @Nullable BlockState getStateForPlacement(BlockPlaceContext var0) {
        Direction[] var4;
        BlockState var1 = this.defaultBlockState();
        Level var2 = var0.getLevel();
        BlockPos var3 = var0.getClickedPos();
        for (Direction var8 : var4 = var0.getNearestLookingDirections()) {
            Direction var9;
            if (!var8.getAxis().isHorizontal() || !(var1 = (BlockState)var1.setValue(FACING, var9 = var8.getOpposite())).canSurvive(var2, var3)) continue;
            return var1;
        }
        return null;
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4.getOpposite() == var0.getValue(FACING) && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return var0;
    }

    @Override
    public void animateTick(BlockState var0, Level var1, BlockPos var2, RandomSource var3) {
        Direction var4 = var0.getValue(FACING);
        double var5 = (double)var2.getX() + 0.5;
        double var7 = (double)var2.getY() + 0.7;
        double var9 = (double)var2.getZ() + 0.5;
        double var11 = 0.22;
        double var13 = 0.27;
        Direction var15 = var4.getOpposite();
        var1.addParticle(ParticleTypes.SMOKE, var5 + 0.27 * (double)var15.getStepX(), var7 + 0.22, var9 + 0.27 * (double)var15.getStepZ(), 0.0, 0.0, 0.0);
        var1.addParticle(this.flameParticle, var5 + 0.27 * (double)var15.getStepX(), var7 + 0.22, var9 + 0.27 * (double)var15.getStepZ(), 0.0, 0.0, 0.0);
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING);
    }
}

