/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class WitherRoseBlock
extends FlowerBlock {
    public static final MapCodec<WitherRoseBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EFFECTS_FIELD.forGetter(FlowerBlock::getSuspiciousEffects), WitherRoseBlock.propertiesCodec()).apply((Applicative)instance, WitherRoseBlock::new));

    public MapCodec<WitherRoseBlock> codec() {
        return CODEC;
    }

    public WitherRoseBlock(Holder<MobEffect> holder, float f, BlockBehaviour.Properties blockbase_info) {
        this(WitherRoseBlock.makeEffectList(holder, f), blockbase_info);
    }

    public WitherRoseBlock(SuspiciousStewEffects suspicioussteweffects, BlockBehaviour.Properties blockbase_info) {
        super(suspicioussteweffects, blockbase_info);
    }

    @Override
    protected boolean mayPlaceOn(BlockState iblockdata, BlockGetter iblockaccess, BlockPos blockposition) {
        return super.mayPlaceOn(iblockdata, iblockaccess, blockposition) || iblockdata.is(Blocks.NETHERRACK) || iblockdata.is(Blocks.SOUL_SAND) || iblockdata.is(Blocks.SOUL_SOIL);
    }

    @Override
    public void animateTick(BlockState iblockdata, Level world, BlockPos blockposition, RandomSource randomsource) {
        VoxelShape voxelshape = this.getShape(iblockdata, world, blockposition, CollisionContext.empty());
        Vec3 vec3d = voxelshape.bounds().getCenter();
        double d0 = (double)blockposition.getX() + vec3d.x;
        double d1 = (double)blockposition.getZ() + vec3d.z;
        for (int i = 0; i < 3; ++i) {
            if (!randomsource.nextBoolean()) continue;
            world.addParticle(ParticleTypes.SMOKE, d0 + randomsource.nextDouble() / 5.0, (double)blockposition.getY() + (0.5 - randomsource.nextDouble()), d1 + randomsource.nextDouble() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void entityInside(BlockState iblockdata, Level world, BlockPos blockposition, Entity entity, InsideBlockEffectApplier insideblockeffectapplier, boolean flag) {
        if (world instanceof ServerLevel) {
            LivingEntity entityliving;
            ServerLevel worldserver = (ServerLevel)world;
            if (world.getDifficulty() != Difficulty.PEACEFUL && entity instanceof LivingEntity && !(entityliving = (LivingEntity)entity).isInvulnerableTo(worldserver, world.damageSources().wither())) {
                entityliving.addEffect(this.getBeeInteractionEffect(), EntityPotionEffectEvent.Cause.WITHER_ROSE);
            }
        }
    }

    @Override
    public MobEffectInstance getBeeInteractionEffect() {
        return new MobEffectInstance(MobEffects.WITHER, 40);
    }
}

