/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ARGB;
import net.minecraft.world.LockCode;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeaconBeamBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BeaconBeamOwner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import org.bukkit.craftbukkit.v1_21_R7.potion.CraftPotionUtil;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.potion.PotionEffect;
import org.jspecify.annotations.Nullable;

public class BeaconBlockEntity
extends BlockEntity
implements MenuProvider,
Nameable,
BeaconBeamOwner {
    private static final int MAX_LEVELS = 4;
    public static final List<List<Holder<MobEffect>>> BEACON_EFFECTS = List.of(List.of(MobEffects.SPEED, MobEffects.HASTE), List.of(MobEffects.RESISTANCE, MobEffects.JUMP_BOOST), List.of(MobEffects.STRENGTH), List.of(MobEffects.REGENERATION));
    private static final Set<Holder<MobEffect>> VALID_EFFECTS = BEACON_EFFECTS.stream().flatMap(Collection::stream).collect(Collectors.toSet());
    public static final int DATA_LEVELS = 0;
    public static final int DATA_PRIMARY = 1;
    public static final int DATA_SECONDARY = 2;
    public static final int NUM_DATA_VALUES = 3;
    private static final int BLOCKS_CHECK_PER_TICK = 10;
    private static final Component DEFAULT_NAME = Component.translatable("container.beacon");
    private static final String TAG_PRIMARY = "primary_effect";
    private static final String TAG_SECONDARY = "secondary_effect";
    List<BeaconBeamOwner.Section> beamSections = new ArrayList<BeaconBeamOwner.Section>();
    private List<BeaconBeamOwner.Section> checkingBeamSections = new ArrayList<BeaconBeamOwner.Section>();
    public int levels;
    private int lastCheckY;
    public @Nullable Holder<MobEffect> primaryPower;
    public @Nullable Holder<MobEffect> secondaryPower;
    public @Nullable Component name;
    public LockCode lockKey = LockCode.NO_LOCK;
    private final ContainerData dataAccess = new ContainerData(){

        @Override
        public int get(int i) {
            return switch (i) {
                case 0 -> BeaconBlockEntity.this.levels;
                case 1 -> BeaconMenu.encodeEffect(BeaconBlockEntity.this.primaryPower);
                case 2 -> BeaconMenu.encodeEffect(BeaconBlockEntity.this.secondaryPower);
                default -> 0;
            };
        }

        @Override
        public void set(int i, int j) {
            switch (i) {
                case 0: {
                    BeaconBlockEntity.this.levels = j;
                    break;
                }
                case 1: {
                    if (!BeaconBlockEntity.this.level.isClientSide() && !BeaconBlockEntity.this.beamSections.isEmpty()) {
                        BeaconBlockEntity.playSound(BeaconBlockEntity.this.level, BeaconBlockEntity.this.worldPosition, SoundEvents.BEACON_POWER_SELECT);
                    }
                    BeaconBlockEntity.this.primaryPower = BeaconBlockEntity.filterEffect(BeaconMenu.decodeEffect(j));
                    break;
                }
                case 2: {
                    BeaconBlockEntity.this.secondaryPower = BeaconBlockEntity.filterEffect(BeaconMenu.decodeEffect(j));
                }
            }
        }

        @Override
        public int getCount() {
            return 3;
        }
    };

    public PotionEffect getPrimaryEffect() {
        return this.primaryPower != null ? CraftPotionUtil.toBukkit(new MobEffectInstance(this.primaryPower, BeaconBlockEntity.getLevel(this.levels), BeaconBlockEntity.getAmplification(this.levels, this.primaryPower, this.secondaryPower), true, true)) : null;
    }

    public PotionEffect getSecondaryEffect() {
        return BeaconBlockEntity.hasSecondaryEffect(this.levels, this.primaryPower, this.secondaryPower) ? CraftPotionUtil.toBukkit(new MobEffectInstance(this.secondaryPower, BeaconBlockEntity.getLevel(this.levels), BeaconBlockEntity.getAmplification(this.levels, this.primaryPower, this.secondaryPower), true, true)) : null;
    }

    static @Nullable Holder<MobEffect> filterEffect(@Nullable Holder<MobEffect> holder) {
        return VALID_EFFECTS.contains(holder) ? holder : null;
    }

    public BeaconBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.BEACON, blockposition, iblockdata);
    }

    public static void tick(Level world, BlockPos blockposition, BlockState iblockdata, BeaconBlockEntity tileentitybeacon) {
        BlockPos blockposition1;
        int i = blockposition.getX();
        int j = blockposition.getY();
        int k = blockposition.getZ();
        if (tileentitybeacon.lastCheckY < j) {
            blockposition1 = blockposition;
            tileentitybeacon.checkingBeamSections = Lists.newArrayList();
            tileentitybeacon.lastCheckY = blockposition.getY() - 1;
        } else {
            blockposition1 = new BlockPos(i, tileentitybeacon.lastCheckY + 1, k);
        }
        BeaconBeamOwner.Section beaconbeamowner_a = tileentitybeacon.checkingBeamSections.isEmpty() ? null : tileentitybeacon.checkingBeamSections.get(tileentitybeacon.checkingBeamSections.size() - 1);
        int l = world.getHeight(Heightmap.Types.WORLD_SURFACE, i, k);
        for (int i1 = 0; i1 < 10 && blockposition1.getY() <= l; ++i1) {
            BlockState iblockdata1 = world.getBlockState(blockposition1);
            Block block = iblockdata1.getBlock();
            if (block instanceof BeaconBeamBlock) {
                BeaconBeamBlock ibeaconbeam = (BeaconBeamBlock)((Object)block);
                int j1 = ibeaconbeam.getColor().getTextureDiffuseColor();
                if (tileentitybeacon.checkingBeamSections.size() <= 1) {
                    beaconbeamowner_a = new BeaconBeamOwner.Section(j1);
                    tileentitybeacon.checkingBeamSections.add(beaconbeamowner_a);
                } else if (beaconbeamowner_a != null) {
                    if (j1 == beaconbeamowner_a.getColor()) {
                        beaconbeamowner_a.increaseHeight();
                    } else {
                        beaconbeamowner_a = new BeaconBeamOwner.Section(ARGB.average(beaconbeamowner_a.getColor(), j1));
                        tileentitybeacon.checkingBeamSections.add(beaconbeamowner_a);
                    }
                }
            } else {
                if (beaconbeamowner_a == null || iblockdata1.getLightBlock() >= 15 && !iblockdata1.is(Blocks.BEDROCK)) {
                    tileentitybeacon.checkingBeamSections.clear();
                    tileentitybeacon.lastCheckY = l;
                    break;
                }
                beaconbeamowner_a.increaseHeight();
            }
            blockposition1 = blockposition1.above();
            ++tileentitybeacon.lastCheckY;
        }
        int k1 = tileentitybeacon.levels;
        if (world.getGameTime() % 80L == 0L) {
            if (!tileentitybeacon.beamSections.isEmpty()) {
                tileentitybeacon.levels = BeaconBlockEntity.updateBase(world, i, j, k);
            }
            if (tileentitybeacon.levels > 0 && !tileentitybeacon.beamSections.isEmpty()) {
                BeaconBlockEntity.applyEffects(world, blockposition, tileentitybeacon.levels, tileentitybeacon.primaryPower, tileentitybeacon.secondaryPower);
                BeaconBlockEntity.playSound(world, blockposition, SoundEvents.BEACON_AMBIENT);
            }
        }
        if (tileentitybeacon.lastCheckY >= l) {
            tileentitybeacon.lastCheckY = world.getMinY() - 1;
            boolean flag = k1 > 0;
            tileentitybeacon.beamSections = tileentitybeacon.checkingBeamSections;
            if (!world.isClientSide()) {
                boolean flag1;
                boolean bl = flag1 = tileentitybeacon.levels > 0;
                if (!flag && flag1) {
                    BeaconBlockEntity.playSound(world, blockposition, SoundEvents.BEACON_ACTIVATE);
                    for (ServerPlayer entityplayer : world.getEntitiesOfClass(ServerPlayer.class, new AABB(i, j, k, i, j - 4, k).inflate(10.0, 5.0, 10.0))) {
                        CriteriaTriggers.CONSTRUCT_BEACON.trigger(entityplayer, tileentitybeacon.levels);
                    }
                } else if (flag && !flag1) {
                    BeaconBlockEntity.playSound(world, blockposition, SoundEvents.BEACON_DEACTIVATE);
                }
            }
        }
    }

    private static int updateBase(Level world, int i, int j, int k) {
        int j1;
        int l = 0;
        int i1 = 1;
        while (i1 <= 4 && (j1 = j - i1) >= world.getMinY()) {
            boolean flag = true;
            block1: for (int k1 = i - i1; k1 <= i + i1 && flag; ++k1) {
                for (int l1 = k - i1; l1 <= k + i1; ++l1) {
                    if (world.getBlockState(new BlockPos(k1, j1, l1)).is(BlockTags.BEACON_BASE_BLOCKS)) continue;
                    flag = false;
                    continue block1;
                }
            }
            if (!flag) break;
            l = i1++;
        }
        return l;
    }

    @Override
    public void setRemoved() {
        BeaconBlockEntity.playSound(this.level, this.worldPosition, SoundEvents.BEACON_DEACTIVATE);
        super.setRemoved();
    }

    private static int getAmplification(int i, @Nullable Holder<MobEffect> holder, @Nullable Holder<MobEffect> holder1) {
        int j = 0;
        if (i >= 4 && Objects.equals(holder, holder1)) {
            j = 1;
        }
        return j;
    }

    private static int getLevel(int i) {
        int k = (9 + i * 2) * 20;
        return k;
    }

    public static List getHumansInRange(Level world, BlockPos blockposition, int i) {
        double d0 = i * 10 + 10;
        AABB axisalignedbb = new AABB(blockposition).inflate(d0).expandTowards(0.0, world.getHeight(), 0.0);
        List<Player> list = world.getEntitiesOfClass(Player.class, axisalignedbb);
        return list;
    }

    private static void applyEffect(List<Player> list, @Nullable Holder<MobEffect> holder, int k, int j) {
        for (Player entityhuman : list) {
            entityhuman.addEffect(new MobEffectInstance(holder, k, j, true, true), EntityPotionEffectEvent.Cause.BEACON);
        }
    }

    private static boolean hasSecondaryEffect(int i, @Nullable Holder<MobEffect> holder, @Nullable Holder<MobEffect> holder1) {
        return i >= 4 && !Objects.equals(holder, holder1) && holder1 != null;
    }

    private static void applyEffects(Level world, BlockPos blockposition, int i, @Nullable Holder<MobEffect> holder, @Nullable Holder<MobEffect> holder1) {
        if (!world.isClientSide() && holder != null) {
            int j = BeaconBlockEntity.getAmplification(i, holder, holder1);
            int k = BeaconBlockEntity.getLevel(i);
            List list = BeaconBlockEntity.getHumansInRange(world, blockposition, i);
            BeaconBlockEntity.applyEffect(list, holder, k, j);
            if (BeaconBlockEntity.hasSecondaryEffect(i, holder, holder1)) {
                BeaconBlockEntity.applyEffect(list, holder1, k, 0);
            }
        }
    }

    public static void playSound(Level world, BlockPos blockposition, SoundEvent soundeffect) {
        world.playSound((Entity)null, blockposition, soundeffect, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    @Override
    public List<BeaconBeamOwner.Section> getBeamSections() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSections;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    private static void storeEffect(ValueOutput valueoutput, String s, @Nullable Holder<MobEffect> holder) {
        if (holder != null) {
            holder.unwrapKey().ifPresent(resourcekey -> valueoutput.putString(s, resourcekey.identifier().toString()));
        }
    }

    private static @Nullable Holder<MobEffect> loadEffect(ValueInput valueinput, String s) {
        Optional<Holder<MobEffect>> optional = valueinput.read(s, BuiltInRegistries.MOB_EFFECT.holderByNameCodec());
        Set<Holder<MobEffect>> set = VALID_EFFECTS;
        Objects.requireNonNull(set);
        return optional.orElse(null);
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.primaryPower = BeaconBlockEntity.loadEffect(valueinput, TAG_PRIMARY);
        this.secondaryPower = BeaconBlockEntity.loadEffect(valueinput, TAG_SECONDARY);
        this.levels = valueinput.getIntOr("Levels", this.levels);
        this.name = BeaconBlockEntity.parseCustomNameSafe(valueinput, "CustomName");
        this.lockKey = LockCode.fromTag(valueinput);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        BeaconBlockEntity.storeEffect(valueoutput, TAG_PRIMARY, this.primaryPower);
        BeaconBlockEntity.storeEffect(valueoutput, TAG_SECONDARY, this.secondaryPower);
        valueoutput.putInt("Levels", this.levels);
        valueoutput.storeNullable("CustomName", ComponentSerialization.CODEC, this.name);
        this.lockKey.addToTag(valueoutput);
    }

    public void setCustomName(@Nullable Component ichatbasecomponent) {
        this.name = ichatbasecomponent;
    }

    @Override
    public @Nullable Component getCustomName() {
        return this.name;
    }

    @Override
    public @Nullable AbstractContainerMenu createMenu(int i, Inventory playerinventory, Player entityhuman) {
        if (this.lockKey.canUnlock(entityhuman)) {
            return new BeaconMenu(i, playerinventory, this.dataAccess, ContainerLevelAccess.create(this.level, this.getBlockPos()));
        }
        BaseContainerBlockEntity.sendChestLockedNotifications(this.getBlockPos().getCenter(), entityhuman, this.getDisplayName());
        return null;
    }

    @Override
    public Component getDisplayName() {
        return this.getName();
    }

    @Override
    public Component getName() {
        return this.name != null ? this.name : DEFAULT_NAME;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        super.applyImplicitComponents(datacomponentgetter);
        this.name = datacomponentgetter.get(DataComponents.CUSTOM_NAME);
        this.lockKey = datacomponentgetter.getOrDefault(DataComponents.LOCK, LockCode.NO_LOCK);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder datacomponentmap_a) {
        super.collectImplicitComponents(datacomponentmap_a);
        datacomponentmap_a.set(DataComponents.CUSTOM_NAME, this.name);
        if (!this.lockKey.equals(LockCode.NO_LOCK)) {
            datacomponentmap_a.set(DataComponents.LOCK, this.lockKey);
        }
    }

    @Override
    public void removeComponentsFromTag(ValueOutput valueoutput) {
        valueoutput.discard("CustomName");
        valueoutput.discard("lock");
    }

    @Override
    public void setLevel(Level world) {
        super.setLevel(world);
        this.lastCheckY = world.getMinY() - 1;
    }
}

