/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.util.debug.DebugHiveInfo;
import net.minecraft.util.debug.DebugSubscriptions;
import net.minecraft.util.debug.DebugValueSource;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.EntityProcessor;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.bee.Bee;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.Bees;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R7.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityEnterBlockEvent;
import org.bukkit.event.entity.EntityRemoveEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class BeehiveBlockEntity
extends BlockEntity {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_FLOWER_POS = "flower_pos";
    private static final String BEES = "bees";
    static final List<String> IGNORED_BEE_TAGS = Arrays.asList("Air", "drop_chances", "equipment", "Brain", "CanPickUpLoot", "DeathTime", "fall_distance", "FallFlying", "Fire", "HurtByTimestamp", "HurtTime", "LeftHanded", "Motion", "NoGravity", "OnGround", "PortalCooldown", "Pos", "Rotation", "sleeping_pos", "CannotEnterHiveTicks", "TicksSincePollination", "CropsGrownSincePollination", "hive_pos", "Passengers", "leash", "UUID");
    public static final int MAX_OCCUPANTS = 3;
    private static final int MIN_TICKS_BEFORE_REENTERING_HIVE = 400;
    private static final int MIN_OCCUPATION_TICKS_NECTAR = 2400;
    public static final int MIN_OCCUPATION_TICKS_NECTARLESS = 600;
    private List<BeeData> stored = Lists.newArrayList();
    public @Nullable BlockPos savedFlowerPos;
    public int maxBees = 3;

    public BeehiveBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.BEEHIVE, blockposition, iblockdata);
    }

    @Override
    public void setChanged() {
        if (this.isFireNearby()) {
            this.emptyAllLivingFromHive(null, this.level.getBlockState(this.getBlockPos()), BeeReleaseStatus.EMERGENCY);
        }
        super.setChanged();
    }

    public boolean isFireNearby() {
        if (this.level == null) {
            return false;
        }
        for (BlockPos blockposition : BlockPos.betweenClosed(this.worldPosition.offset(-1, -1, -1), this.worldPosition.offset(1, 1, 1))) {
            if (!(this.level.getBlockState(blockposition).getBlock() instanceof FireBlock)) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.stored.isEmpty();
    }

    public boolean isFull() {
        return this.stored.size() == this.maxBees;
    }

    public void emptyAllLivingFromHive(@Nullable Player entityhuman, BlockState iblockdata, BeeReleaseStatus tileentitybeehive_releasestatus) {
        List<net.minecraft.world.entity.Entity> list = this.releaseAllOccupants(iblockdata, tileentitybeehive_releasestatus);
        if (entityhuman != null) {
            for (net.minecraft.world.entity.Entity entity : list) {
                if (!(entity instanceof Bee)) continue;
                Bee entitybee = (Bee)entity;
                if (!(entityhuman.position().distanceToSqr(entity.position()) <= 16.0)) continue;
                if (!this.isSedated()) {
                    entitybee.setTarget(entityhuman, EntityTargetEvent.TargetReason.CLOSEST_PLAYER, true);
                    continue;
                }
                entitybee.setStayOutOfHiveCountdown(400);
            }
        }
    }

    private List<net.minecraft.world.entity.Entity> releaseAllOccupants(BlockState iblockdata, BeeReleaseStatus tileentitybeehive_releasestatus) {
        return this.releaseBees(iblockdata, tileentitybeehive_releasestatus, false);
    }

    public List<net.minecraft.world.entity.Entity> releaseBees(BlockState iblockdata, BeeReleaseStatus tileentitybeehive_releasestatus, boolean force) {
        ArrayList list = Lists.newArrayList();
        this.stored.removeIf(tileentitybeehive_hivebee -> BeehiveBlockEntity.releaseOccupant(this.level, this.worldPosition, iblockdata, tileentitybeehive_hivebee.toOccupant(), list, tileentitybeehive_releasestatus, this.savedFlowerPos, force));
        if (!list.isEmpty()) {
            super.setChanged();
        }
        return list;
    }

    @VisibleForDebug
    public int getOccupantCount() {
        return this.stored.size();
    }

    public static int getHoneyLevel(BlockState iblockdata) {
        return iblockdata.getValue(BeehiveBlock.HONEY_LEVEL);
    }

    @VisibleForDebug
    public boolean isSedated() {
        return CampfireBlock.isSmokeyPos(this.level, this.getBlockPos());
    }

    public void addOccupant(Bee entitybee) {
        if (this.stored.size() < this.maxBees) {
            if (this.level != null) {
                EntityEnterBlockEvent event = new EntityEnterBlockEvent((Entity)entitybee.getBukkitEntity(), (Block)CraftBlock.at(this.level, this.getBlockPos()));
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    entitybee.setStayOutOfHiveCountdown(400);
                    return;
                }
            }
            entitybee.stopRiding();
            entitybee.ejectPassengers();
            entitybee.dropLeash();
            this.storeBee(Occupant.of(entitybee));
            if (this.level != null) {
                if (entitybee.hasSavedFlowerPos() && (!this.hasSavedFlowerPos() || this.level.random.nextBoolean())) {
                    this.savedFlowerPos = entitybee.getSavedFlowerPos();
                }
                BlockPos blockposition = this.getBlockPos();
                this.level.playSound((net.minecraft.world.entity.Entity)null, (double)blockposition.getX(), (double)blockposition.getY(), (double)blockposition.getZ(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
                this.level.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entitybee, this.getBlockState()));
            }
            entitybee.discard(EntityRemoveEvent.Cause.ENTER_BLOCK);
            super.setChanged();
        }
    }

    public void storeBee(Occupant tileentitybeehive_c) {
        this.stored.add(new BeeData(tileentitybeehive_c));
    }

    private static boolean releaseOccupant(Level world, BlockPos blockposition, BlockState iblockdata, Occupant tileentitybeehive_c, @Nullable List<net.minecraft.world.entity.Entity> list, BeeReleaseStatus tileentitybeehive_releasestatus, @Nullable BlockPos blockposition1) {
        return BeehiveBlockEntity.releaseOccupant(world, blockposition, iblockdata, tileentitybeehive_c, list, tileentitybeehive_releasestatus, blockposition1, false);
    }

    private static boolean releaseOccupant(Level world, BlockPos blockposition, BlockState iblockdata, Occupant tileentitybeehive_c, @Nullable List<net.minecraft.world.entity.Entity> list, BeeReleaseStatus tileentitybeehive_releasestatus, @Nullable BlockPos blockposition1, boolean force) {
        boolean flag;
        if (!force && world.environmentAttributes().getValue(EnvironmentAttributes.BEES_STAY_IN_HIVE, blockposition).booleanValue() && tileentitybeehive_releasestatus != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        Direction enumdirection = iblockdata.getValue(BeehiveBlock.FACING);
        BlockPos blockposition2 = blockposition.relative(enumdirection);
        boolean bl = flag = !world.getBlockState(blockposition2).getCollisionShape(world, blockposition2).isEmpty();
        if (flag && tileentitybeehive_releasestatus != BeeReleaseStatus.EMERGENCY) {
            return false;
        }
        net.minecraft.world.entity.Entity entity = tileentitybeehive_c.createEntity(world, blockposition);
        if (entity != null) {
            if (entity instanceof Bee) {
                float f = entity.getBbWidth();
                double d0 = flag ? 0.0 : 0.55 + (double)(f / 2.0f);
                double d1 = (double)blockposition.getX() + 0.5 + d0 * (double)enumdirection.getStepX();
                double d2 = (double)blockposition.getY() + 0.5 - (double)(entity.getBbHeight() / 2.0f);
                double d3 = (double)blockposition.getZ() + 0.5 + d0 * (double)enumdirection.getStepZ();
                entity.snapTo(d1, d2, d3, entity.getYRot(), entity.getXRot());
            }
            if (!world.addFreshEntity(entity, CreatureSpawnEvent.SpawnReason.BEEHIVE)) {
                return false;
            }
            if (entity instanceof Bee) {
                Bee entitybee = (Bee)entity;
                if (blockposition1 != null && !entitybee.hasSavedFlowerPos() && world.random.nextFloat() < 0.9f) {
                    entitybee.setSavedFlowerPos(blockposition1);
                }
                if (tileentitybeehive_releasestatus == BeeReleaseStatus.HONEY_DELIVERED) {
                    int i;
                    entitybee.dropOffNectar();
                    if (iblockdata.is(BlockTags.BEEHIVES, blockbase_blockdata -> blockbase_blockdata.hasProperty(BeehiveBlock.HONEY_LEVEL)) && (i = BeehiveBlockEntity.getHoneyLevel(iblockdata)) < 5) {
                        int j;
                        int n = j = world.random.nextInt(100) == 0 ? 2 : 1;
                        if (i + j > 5) {
                            --j;
                        }
                        world.setBlockAndUpdate(blockposition, (BlockState)iblockdata.setValue(BeehiveBlock.HONEY_LEVEL, i + j));
                    }
                }
                if (list != null) {
                    list.add(entitybee);
                }
            }
            world.playSound((net.minecraft.world.entity.Entity)null, blockposition, SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.gameEvent(GameEvent.BLOCK_CHANGE, blockposition, GameEvent.Context.of(entity, world.getBlockState(blockposition)));
            return true;
        }
        return false;
    }

    private boolean hasSavedFlowerPos() {
        return this.savedFlowerPos != null;
    }

    private static void tickOccupants(Level world, BlockPos blockposition, BlockState iblockdata, List<BeeData> list, @Nullable BlockPos blockposition1) {
        boolean flag = false;
        Iterator<BeeData> iterator = list.iterator();
        while (iterator.hasNext()) {
            BeeReleaseStatus tileentitybeehive_releasestatus;
            BeeData tileentitybeehive_hivebee = iterator.next();
            if (!tileentitybeehive_hivebee.tick()) continue;
            BeeReleaseStatus beeReleaseStatus = tileentitybeehive_releasestatus = tileentitybeehive_hivebee.hasNectar() ? BeeReleaseStatus.HONEY_DELIVERED : BeeReleaseStatus.BEE_RELEASED;
            if (BeehiveBlockEntity.releaseOccupant(world, blockposition, iblockdata, tileentitybeehive_hivebee.toOccupant(), null, tileentitybeehive_releasestatus, blockposition1)) {
                flag = true;
                iterator.remove();
                continue;
            }
            tileentitybeehive_hivebee.ticksInHive = tileentitybeehive_hivebee.occupant.minTicksInHive / 2;
        }
        if (flag) {
            BeehiveBlockEntity.setChanged(world, blockposition, iblockdata);
        }
    }

    public static void serverTick(Level world, BlockPos blockposition, BlockState iblockdata, BeehiveBlockEntity tileentitybeehive) {
        BeehiveBlockEntity.tickOccupants(world, blockposition, iblockdata, tileentitybeehive.stored, tileentitybeehive.savedFlowerPos);
        if (!tileentitybeehive.stored.isEmpty() && world.getRandom().nextDouble() < 0.005) {
            double d0 = (double)blockposition.getX() + 0.5;
            double d1 = blockposition.getY();
            double d2 = (double)blockposition.getZ() + 0.5;
            world.playSound((net.minecraft.world.entity.Entity)null, d0, d1, d2, SoundEvents.BEEHIVE_WORK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.stored = Lists.newArrayList();
        valueinput.read(BEES, Occupant.LIST_CODEC).orElse(List.of()).forEach(this::storeBee);
        this.savedFlowerPos = valueinput.read(TAG_FLOWER_POS, BlockPos.CODEC).orElse(null);
        this.maxBees = valueinput.getIntOr("Bukkit.MaxEntities", this.maxBees);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        valueoutput.store(BEES, Occupant.LIST_CODEC, this.getBees());
        valueoutput.storeNullable(TAG_FLOWER_POS, BlockPos.CODEC, this.savedFlowerPos);
        valueoutput.putInt("Bukkit.MaxEntities", this.maxBees);
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        super.applyImplicitComponents(datacomponentgetter);
        this.stored = Lists.newArrayList();
        List<Occupant> list = datacomponentgetter.getOrDefault(DataComponents.BEES, Bees.EMPTY).bees();
        list.forEach(this::storeBee);
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder datacomponentmap_a) {
        super.collectImplicitComponents(datacomponentmap_a);
        datacomponentmap_a.set(DataComponents.BEES, new Bees(this.getBees()));
    }

    @Override
    public void removeComponentsFromTag(ValueOutput valueoutput) {
        super.removeComponentsFromTag(valueoutput);
        valueoutput.discard(BEES);
    }

    private List<Occupant> getBees() {
        return this.stored.stream().map(BeeData::toOccupant).toList();
    }

    @Override
    public void registerDebugValues(ServerLevel worldserver, DebugValueSource.Registration debugvaluesource_a) {
        debugvaluesource_a.register(DebugSubscriptions.BEE_HIVES, () -> DebugHiveInfo.pack(this));
    }

    public static enum BeeReleaseStatus {
        HONEY_DELIVERED,
        BEE_RELEASED,
        EMERGENCY;

    }

    public record Occupant(TypedEntityData<EntityType<?>> entityData, int ticksInHive, int minTicksInHive) {
        public static final Codec<Occupant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TypedEntityData.codec(EntityType.CODEC).fieldOf("entity_data").forGetter(Occupant::entityData), (App)Codec.INT.fieldOf("ticks_in_hive").forGetter(Occupant::ticksInHive), (App)Codec.INT.fieldOf("min_ticks_in_hive").forGetter(Occupant::minTicksInHive)).apply((Applicative)instance, Occupant::new));
        public static final Codec<List<Occupant>> LIST_CODEC = CODEC.listOf();
        public static final StreamCodec<RegistryFriendlyByteBuf, Occupant> STREAM_CODEC = StreamCodec.composite(TypedEntityData.streamCodec(EntityType.STREAM_CODEC), Occupant::entityData, ByteBufCodecs.VAR_INT, Occupant::ticksInHive, ByteBufCodecs.VAR_INT, Occupant::minTicksInHive, Occupant::new);

        public static Occupant of(net.minecraft.world.entity.Entity entity) {
            Occupant tileentitybeehive_c;
            try (ProblemReporter.ScopedCollector problemreporter_j = new ProblemReporter.ScopedCollector(entity.problemPath(), LOGGER);){
                TagValueOutput tagvalueoutput = TagValueOutput.createWithContext(problemreporter_j, entity.registryAccess());
                entity.save(tagvalueoutput);
                List<String> list = IGNORED_BEE_TAGS;
                Objects.requireNonNull(tagvalueoutput);
                list.forEach(tagvalueoutput::discard);
                CompoundTag nbttagcompound = tagvalueoutput.buildResult();
                boolean flag = nbttagcompound.getBooleanOr("HasNectar", false);
                tileentitybeehive_c = new Occupant(TypedEntityData.of(entity.getType(), nbttagcompound), 0, flag ? 2400 : 600);
            }
            return tileentitybeehive_c;
        }

        public static Occupant create(int i) {
            return new Occupant(TypedEntityData.of(EntityType.BEE, new CompoundTag()), i, 600);
        }

        public @Nullable net.minecraft.world.entity.Entity createEntity(Level world, BlockPos blockposition) {
            CompoundTag nbttagcompound = this.entityData.copyTagWithoutId();
            List<String> list = IGNORED_BEE_TAGS;
            Objects.requireNonNull(nbttagcompound);
            list.forEach(nbttagcompound::remove);
            net.minecraft.world.entity.Entity entity = EntityType.loadEntityRecursive(this.entityData.type(), nbttagcompound, world, EntitySpawnReason.LOAD, EntityProcessor.NOP);
            if (entity != null && entity.getType().is(EntityTypeTags.BEEHIVE_INHABITORS)) {
                entity.setNoGravity(true);
                if (entity instanceof Bee) {
                    Bee entitybee = (Bee)entity;
                    entitybee.setHivePos(blockposition);
                    Occupant.setBeeReleaseData(this.ticksInHive, entitybee);
                }
                return entity;
            }
            return null;
        }

        private static void setBeeReleaseData(int i, Bee entitybee) {
            int j = entitybee.getAge();
            if (j < 0) {
                entitybee.setAge(Math.min(0, j + i));
            } else if (j > 0) {
                entitybee.setAge(Math.max(0, j - i));
            }
            entitybee.setInLoveTime(Math.max(0, entitybee.getInLoveTime() - i));
        }
    }

    private static class BeeData {
        private final Occupant occupant;
        private int ticksInHive;

        BeeData(Occupant tileentitybeehive_c) {
            this.occupant = tileentitybeehive_c;
            this.ticksInHive = tileentitybeehive_c.ticksInHive();
        }

        public boolean tick() {
            return this.ticksInHive++ > this.occupant.minTicksInHive;
        }

        public Occupant toOccupant() {
            return new Occupant(this.occupant.entityData, this.ticksInHive, this.occupant.minTicksInHive);
        }

        public boolean hasNectar() {
            return this.occupant.entityData.getUnsafe().getBooleanOr("HasNectar", false);
        }
    }
}

