/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.permissions.LevelBasedPermissionSet;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R7.command.CraftBlockCommandSender;

public class CommandBlockEntity
extends BlockEntity {
    private static final boolean DEFAULT_POWERED = false;
    private static final boolean DEFAULT_CONDITION_MET = false;
    private static final boolean DEFAULT_AUTOMATIC = false;
    private boolean powered = false;
    private boolean auto = false;
    private boolean conditionMet = false;
    private final BaseCommandBlock commandBlock = new BaseCommandBlock(){

        @Override
        public CommandSender getBukkitSender(CommandSourceStack wrapper) {
            return new CraftBlockCommandSender(wrapper, CommandBlockEntity.this);
        }

        @Override
        public void setCommand(String s) {
            super.setCommand(s);
            CommandBlockEntity.this.setChanged();
        }

        @Override
        public void onUpdated(ServerLevel worldserver) {
            BlockState iblockdata = worldserver.getBlockState(CommandBlockEntity.this.worldPosition);
            worldserver.sendBlockUpdated(CommandBlockEntity.this.worldPosition, iblockdata, iblockdata, 3);
        }

        @Override
        public CommandSourceStack createCommandSourceStack(ServerLevel worldserver, CommandSource icommandlistener) {
            Direction enumdirection = CommandBlockEntity.this.getBlockState().getValue(CommandBlock.FACING);
            return new CommandSourceStack(icommandlistener, Vec3.atCenterOf(CommandBlockEntity.this.worldPosition), new Vec2(0.0f, enumdirection.toYRot()), worldserver, LevelBasedPermissionSet.GAMEMASTER, this.getName().getString(), this.getName(), worldserver.getServer(), null);
        }

        @Override
        public boolean isValid() {
            return !CommandBlockEntity.this.isRemoved();
        }
    };

    public CommandBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.COMMAND_BLOCK, blockposition, iblockdata);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        this.commandBlock.save(valueoutput);
        valueoutput.putBoolean("powered", this.isPowered());
        valueoutput.putBoolean("conditionMet", this.wasConditionMet());
        valueoutput.putBoolean("auto", this.isAutomatic());
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.commandBlock.load(valueinput);
        this.powered = valueinput.getBooleanOr("powered", false);
        this.conditionMet = valueinput.getBooleanOr("conditionMet", false);
        this.setAutomatic(valueinput.getBooleanOr("auto", false));
    }

    public BaseCommandBlock getCommandBlock() {
        return this.commandBlock;
    }

    public void setPowered(boolean flag) {
        this.powered = flag;
    }

    public boolean isPowered() {
        return this.powered;
    }

    public boolean isAutomatic() {
        return this.auto;
    }

    public void setAutomatic(boolean flag) {
        boolean flag1 = this.auto;
        this.auto = flag;
        if (!flag1 && flag && !this.powered && this.level != null && this.getMode() != Mode.SEQUENCE) {
            this.scheduleTick();
        }
    }

    public void onModeSwitch() {
        Mode tileentitycommand_type = this.getMode();
        if (tileentitycommand_type == Mode.AUTO && (this.powered || this.auto) && this.level != null) {
            this.scheduleTick();
        }
    }

    private void scheduleTick() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof CommandBlock) {
            this.markConditionMet();
            this.level.scheduleTick(this.worldPosition, block, 1);
        }
    }

    public boolean wasConditionMet() {
        return this.conditionMet;
    }

    public boolean markConditionMet() {
        this.conditionMet = true;
        if (this.isConditional()) {
            BlockEntity tileentity;
            BlockPos blockposition = this.worldPosition.relative(this.level.getBlockState(this.worldPosition).getValue(CommandBlock.FACING).getOpposite());
            this.conditionMet = this.level.getBlockState(blockposition).getBlock() instanceof CommandBlock ? (tileentity = this.level.getBlockEntity(blockposition)) instanceof CommandBlockEntity && ((CommandBlockEntity)tileentity).getCommandBlock().getSuccessCount() > 0 : false;
        }
        return this.conditionMet;
    }

    public Mode getMode() {
        BlockState iblockdata = this.getBlockState();
        return iblockdata.is(Blocks.COMMAND_BLOCK) ? Mode.REDSTONE : (iblockdata.is(Blocks.REPEATING_COMMAND_BLOCK) ? Mode.AUTO : (iblockdata.is(Blocks.CHAIN_COMMAND_BLOCK) ? Mode.SEQUENCE : Mode.REDSTONE));
    }

    public boolean isConditional() {
        BlockState iblockdata = this.level.getBlockState(this.getBlockPos());
        return iblockdata.getBlock() instanceof CommandBlock ? iblockdata.getValue(CommandBlock.CONDITIONAL) : false;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter datacomponentgetter) {
        super.applyImplicitComponents(datacomponentgetter);
        this.commandBlock.setCustomName(datacomponentgetter.get(DataComponents.CUSTOM_NAME));
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder datacomponentmap_a) {
        super.collectImplicitComponents(datacomponentmap_a);
        datacomponentmap_a.set(DataComponents.CUSTOM_NAME, this.commandBlock.getCustomName());
    }

    @Override
    public void removeComponentsFromTag(ValueOutput valueoutput) {
        super.removeComponentsFromTag(valueoutput);
        valueoutput.discard("CustomName");
        valueoutput.discard("conditionMet");
        valueoutput.discard("powered");
    }

    public static enum Mode {
        SEQUENCE,
        AUTO,
        REDSTONE;

    }
}

