/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipProvider;

public record PotDecorations(Optional<Item> back, Optional<Item> left, Optional<Item> right, Optional<Item> front) implements TooltipProvider
{
    public static final PotDecorations EMPTY = new PotDecorations(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static final Codec<PotDecorations> CODEC = BuiltInRegistries.ITEM.byNameCodec().sizeLimitedListOf(4).xmap(PotDecorations::new, PotDecorations::ordered);
    public static final StreamCodec<RegistryFriendlyByteBuf, PotDecorations> STREAM_CODEC = ByteBufCodecs.registry(Registries.ITEM).apply(ByteBufCodecs.list(4)).map(PotDecorations::new, PotDecorations::ordered);

    private PotDecorations(List<Item> var0) {
        this(PotDecorations.getItem(var0, 0), PotDecorations.getItem(var0, 1), PotDecorations.getItem(var0, 2), PotDecorations.getItem(var0, 3));
    }

    public PotDecorations(Item var0, Item var1, Item var2, Item var3) {
        this(List.of(var0, var1, var2, var3));
    }

    private static Optional<Item> getItem(List<Item> var0, int var1) {
        if (var1 >= var0.size()) {
            return Optional.empty();
        }
        Item var2 = var0.get(var1);
        return var2 == Items.BRICK ? Optional.empty() : Optional.of(var2);
    }

    public List<Item> ordered() {
        return Stream.of(this.back, this.left, this.right, this.front).map(var0 -> var0.orElse(Items.BRICK)).toList();
    }

    @Override
    public void addToTooltip(Item.TooltipContext var0, Consumer<Component> var1, TooltipFlag var2, DataComponentGetter var3) {
        if (this.equals(EMPTY)) {
            return;
        }
        var1.accept(CommonComponents.EMPTY);
        PotDecorations.addSideDetailsToTooltip(var1, this.front);
        PotDecorations.addSideDetailsToTooltip(var1, this.left);
        PotDecorations.addSideDetailsToTooltip(var1, this.right);
        PotDecorations.addSideDetailsToTooltip(var1, this.back);
    }

    private static void addSideDetailsToTooltip(Consumer<Component> var0, Optional<Item> var1) {
        var0.accept(new ItemStack(var1.orElse(Items.BRICK), 1).getHoverName().plainCopy().withStyle(ChatFormatting.GRAY));
    }
}

