/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jspecify.annotations.Nullable;

public abstract class RandomizableContainerBlockEntity
extends BaseContainerBlockEntity
implements RandomizableContainer {
    public @Nullable ResourceKey<LootTable> lootTable;
    public long lootTableSeed = 0L;

    protected RandomizableContainerBlockEntity(BlockEntityType<?> var0, BlockPos var1, BlockState var2) {
        super(var0, var1, var2);
    }

    @Override
    public @Nullable ResourceKey<LootTable> getLootTable() {
        return this.lootTable;
    }

    @Override
    public void setLootTable(@Nullable ResourceKey<LootTable> var0) {
        this.lootTable = var0;
    }

    @Override
    public long getLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setLootTableSeed(long var0) {
        this.lootTableSeed = var0;
    }

    @Override
    public boolean isEmpty() {
        this.unpackLootTable(null);
        return super.isEmpty();
    }

    @Override
    public ItemStack getItem(int var0) {
        this.unpackLootTable(null);
        return super.getItem(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        this.unpackLootTable(null);
        return super.removeItem(var0, var1);
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        this.unpackLootTable(null);
        return super.removeItemNoUpdate(var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.unpackLootTable(null);
        super.setItem(var0, var1);
    }

    @Override
    public boolean canOpen(Player var0) {
        return super.canOpen(var0) && (this.lootTable == null || !var0.isSpectator());
    }

    @Override
    public @Nullable AbstractContainerMenu createMenu(int var0, Inventory var1, Player var2) {
        if (this.canOpen(var2)) {
            this.unpackLootTable(var1.player);
            return this.createMenu(var0, var1);
        }
        BaseContainerBlockEntity.sendChestLockedNotifications(this.getBlockPos().getCenter(), var2, this.getDisplayName());
        return null;
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter var0) {
        super.applyImplicitComponents(var0);
        SeededContainerLoot var1 = var0.get(DataComponents.CONTAINER_LOOT);
        if (var1 != null) {
            this.lootTable = var1.lootTable();
            this.lootTableSeed = var1.seed();
        }
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder var0) {
        super.collectImplicitComponents(var0);
        if (this.lootTable != null) {
            var0.set(DataComponents.CONTAINER_LOOT, new SeededContainerLoot(this.lootTable, this.lootTableSeed));
        }
    }

    @Override
    public void removeComponentsFromTag(ValueOutput var0) {
        super.removeComponentsFromTag(var0);
        var0.discard("LootTable");
        var0.discard("LootTableSeed");
    }
}

