/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.TheEndPortalBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.EndGatewayConfiguration;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class TheEndGatewayBlockEntity
extends TheEndPortalBlockEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SPAWN_TIME = 200;
    private static final int COOLDOWN_TIME = 40;
    private static final int ATTENTION_INTERVAL = 2400;
    private static final int EVENT_COOLDOWN = 1;
    private static final int GATEWAY_HEIGHT_ABOVE_SURFACE = 10;
    private static final long DEFAULT_AGE = 0L;
    private static final boolean DEFAULT_EXACT_TELEPORT = false;
    public long age = 0L;
    private int teleportCooldown;
    public @Nullable BlockPos exitPortal;
    public boolean exactTeleport = false;

    public TheEndGatewayBlockEntity(BlockPos blockposition, BlockState iblockdata) {
        super(BlockEntityType.END_GATEWAY, blockposition, iblockdata);
    }

    @Override
    protected void saveAdditional(ValueOutput valueoutput) {
        super.saveAdditional(valueoutput);
        valueoutput.putLong("Age", this.age);
        valueoutput.storeNullable("exit_portal", BlockPos.CODEC, this.exitPortal);
        if (this.exactTeleport) {
            valueoutput.putBoolean("ExactTeleport", true);
        }
    }

    @Override
    protected void loadAdditional(ValueInput valueinput) {
        super.loadAdditional(valueinput);
        this.age = valueinput.getLongOr("Age", 0L);
        this.exitPortal = valueinput.read("exit_portal", BlockPos.CODEC).filter(Level::isInSpawnableBounds).orElse(null);
        this.exactTeleport = valueinput.getBooleanOr("ExactTeleport", false);
    }

    public static void beamAnimationTick(Level world, BlockPos blockposition, BlockState iblockdata, TheEndGatewayBlockEntity tileentityendgateway) {
        ++tileentityendgateway.age;
        if (tileentityendgateway.isCoolingDown()) {
            --tileentityendgateway.teleportCooldown;
        }
    }

    public static void portalTick(Level world, BlockPos blockposition, BlockState iblockdata, TheEndGatewayBlockEntity tileentityendgateway) {
        boolean flag = tileentityendgateway.isSpawning();
        boolean flag1 = tileentityendgateway.isCoolingDown();
        ++tileentityendgateway.age;
        if (flag1) {
            --tileentityendgateway.teleportCooldown;
        } else if (tileentityendgateway.age % 2400L == 0L) {
            TheEndGatewayBlockEntity.triggerCooldown(world, blockposition, iblockdata, tileentityendgateway);
        }
        if (flag != tileentityendgateway.isSpawning() || flag1 != tileentityendgateway.isCoolingDown()) {
            TheEndGatewayBlockEntity.setChanged(world, blockposition, iblockdata);
        }
    }

    public boolean isSpawning() {
        return this.age < 200L;
    }

    public boolean isCoolingDown() {
        return this.teleportCooldown > 0;
    }

    public float getSpawnPercent(float f) {
        return Mth.clamp(((float)this.age + f) / 200.0f, 0.0f, 1.0f);
    }

    public float getCooldownPercent(float f) {
        return 1.0f - Mth.clamp(((float)this.teleportCooldown - f) / 40.0f, 0.0f, 1.0f);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create(this);
    }

    @Override
    public CompoundTag getUpdateTag(HolderLookup.Provider holderlookup_a) {
        return this.saveCustomOnly(holderlookup_a);
    }

    public static void triggerCooldown(Level world, BlockPos blockposition, BlockState iblockdata, TheEndGatewayBlockEntity tileentityendgateway) {
        if (!world.isClientSide()) {
            tileentityendgateway.teleportCooldown = 40;
            world.blockEvent(blockposition, iblockdata.getBlock(), 1, 0);
            TheEndGatewayBlockEntity.setChanged(world, blockposition, iblockdata);
        }
    }

    @Override
    public boolean triggerEvent(int i, int j) {
        if (i == 1) {
            this.teleportCooldown = 40;
            return true;
        }
        return super.triggerEvent(i, j);
    }

    public @Nullable Vec3 getPortalPosition(ServerLevel worldserver, BlockPos blockposition) {
        if (this.exitPortal == null && worldserver.getTypeKey() == LevelStem.END) {
            BlockPos blockposition1 = TheEndGatewayBlockEntity.findOrCreateValidTeleportPos(worldserver, blockposition);
            blockposition1 = blockposition1.above(10);
            LOGGER.debug("Creating portal at {}", (Object)blockposition1);
            TheEndGatewayBlockEntity.spawnGatewayPortal(worldserver, blockposition1, EndGatewayConfiguration.knownExit(blockposition, false));
            this.setExitPosition(blockposition1, this.exactTeleport);
        }
        if (this.exitPortal != null) {
            BlockPos blockposition2 = this.exactTeleport ? this.exitPortal : TheEndGatewayBlockEntity.findExitPosition(worldserver, this.exitPortal);
            return blockposition2.getBottomCenter();
        }
        return null;
    }

    private static BlockPos findExitPosition(Level world, BlockPos blockposition) {
        BlockPos blockposition1 = TheEndGatewayBlockEntity.findTallestBlock(world, blockposition.offset(0, 2, 0), 5, false);
        LOGGER.debug("Best exit position for portal at {} is {}", (Object)blockposition, (Object)blockposition1);
        return blockposition1.above();
    }

    private static BlockPos findOrCreateValidTeleportPos(ServerLevel worldserver, BlockPos blockposition) {
        Vec3 vec3d = TheEndGatewayBlockEntity.findExitPortalXZPosTentative(worldserver, blockposition);
        LevelChunk chunk = TheEndGatewayBlockEntity.getChunk(worldserver, vec3d);
        BlockPos blockposition1 = TheEndGatewayBlockEntity.findValidSpawnInChunk(chunk);
        if (blockposition1 == null) {
            BlockPos blockposition2 = BlockPos.containing(vec3d.x + 0.5, 75.0, vec3d.z + 0.5);
            LOGGER.debug("Failed to find a suitable block to teleport to, spawning an island on {}", (Object)blockposition2);
            worldserver.registryAccess().lookup(Registries.CONFIGURED_FEATURE).flatMap(iregistry -> iregistry.get(EndFeatures.END_ISLAND)).ifPresent(holder_c -> ((ConfiguredFeature)holder_c.value()).place(worldserver, worldserver.getChunkSource().getGenerator(), RandomSource.create(blockposition2.asLong()), blockposition2));
            blockposition1 = blockposition2;
        } else {
            LOGGER.debug("Found suitable block to teleport to: {}", (Object)blockposition1);
        }
        return TheEndGatewayBlockEntity.findTallestBlock(worldserver, blockposition1, 16, true);
    }

    private static Vec3 findExitPortalXZPosTentative(ServerLevel worldserver, BlockPos blockposition) {
        Vec3 vec3d = new Vec3(blockposition.getX(), 0.0, blockposition.getZ()).normalize();
        int i = 1024;
        Vec3 vec3d1 = vec3d.scale(1024.0);
        int j = 16;
        while (!TheEndGatewayBlockEntity.isChunkEmpty(worldserver, vec3d1) && j-- > 0) {
            LOGGER.debug("Skipping backwards past nonempty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.add(vec3d.scale(-16.0));
        }
        int k = 16;
        while (TheEndGatewayBlockEntity.isChunkEmpty(worldserver, vec3d1) && k-- > 0) {
            LOGGER.debug("Skipping forward past empty chunk at {}", (Object)vec3d1);
            vec3d1 = vec3d1.add(vec3d.scale(16.0));
        }
        LOGGER.debug("Found chunk at {}", (Object)vec3d1);
        return vec3d1;
    }

    private static boolean isChunkEmpty(ServerLevel worldserver, Vec3 vec3d) {
        return TheEndGatewayBlockEntity.getChunk(worldserver, vec3d).getHighestFilledSectionIndex() == -1;
    }

    private static BlockPos findTallestBlock(BlockGetter iblockaccess, BlockPos blockposition, int i, boolean flag) {
        Vec3i blockposition1 = null;
        for (int j = -i; j <= i; ++j) {
            block1: for (int k = -i; k <= i; ++k) {
                if (j == 0 && k == 0 && !flag) continue;
                for (int l = iblockaccess.getMaxY(); l > (blockposition1 == null ? iblockaccess.getMinY() : blockposition1.getY()); --l) {
                    BlockPos blockposition2 = new BlockPos(blockposition.getX() + j, l, blockposition.getZ() + k);
                    BlockState iblockdata = iblockaccess.getBlockState(blockposition2);
                    if (!iblockdata.isCollisionShapeFullBlock(iblockaccess, blockposition2) || !flag && iblockdata.is(Blocks.BEDROCK)) continue;
                    blockposition1 = blockposition2;
                    continue block1;
                }
            }
        }
        return blockposition1 == null ? blockposition : blockposition1;
    }

    private static LevelChunk getChunk(Level world, Vec3 vec3d) {
        return world.getChunk(Mth.floor(vec3d.x / 16.0), Mth.floor(vec3d.z / 16.0));
    }

    private static @Nullable BlockPos findValidSpawnInChunk(LevelChunk chunk) {
        ChunkPos chunkcoordintpair = chunk.getPos();
        BlockPos blockposition = new BlockPos(chunkcoordintpair.getMinBlockX(), 30, chunkcoordintpair.getMinBlockZ());
        int i = chunk.getHighestSectionPosition() + 16 - 1;
        BlockPos blockposition1 = new BlockPos(chunkcoordintpair.getMaxBlockX(), i, chunkcoordintpair.getMaxBlockZ());
        BlockPos blockposition2 = null;
        double d0 = 0.0;
        for (BlockPos blockposition3 : BlockPos.betweenClosed(blockposition, blockposition1)) {
            BlockState iblockdata = chunk.getBlockState(blockposition3);
            BlockPos blockposition4 = blockposition3.above();
            BlockPos blockposition5 = blockposition3.above(2);
            if (!iblockdata.is(Blocks.END_STONE) || chunk.getBlockState(blockposition4).isCollisionShapeFullBlock(chunk, blockposition4) || chunk.getBlockState(blockposition5).isCollisionShapeFullBlock(chunk, blockposition5)) continue;
            double d1 = blockposition3.distToCenterSqr(0.0, 0.0, 0.0);
            if (blockposition2 != null && !(d1 < d0)) continue;
            blockposition2 = blockposition3;
            d0 = d1;
        }
        return blockposition2;
    }

    private static void spawnGatewayPortal(ServerLevel worldserver, BlockPos blockposition, EndGatewayConfiguration worldgenendgatewayconfiguration) {
        Feature.END_GATEWAY.place(worldgenendgatewayconfiguration, worldserver, worldserver.getChunkSource().getGenerator(), RandomSource.create(), blockposition);
    }

    @Override
    public boolean shouldRenderFace(Direction enumdirection) {
        return Block.shouldRenderFace(this.getBlockState(), this.level.getBlockState(this.getBlockPos().relative(enumdirection)), enumdirection);
    }

    public int getParticleAmount() {
        int i = 0;
        for (Direction enumdirection : Direction.values()) {
            i += this.shouldRenderFace(enumdirection) ? 1 : 0;
        }
        return i;
    }

    public void setExitPosition(BlockPos blockposition, boolean flag) {
        this.exactTeleport = flag;
        this.exitPortal = blockposition;
        this.setChanged();
    }
}

