/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.OminousItemSpawner;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerStateData;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jspecify.annotations.Nullable;

public enum TrialSpawnerState implements StringRepresentable
{
    INACTIVE("inactive", 0, ParticleEmission.NONE, -1.0, false),
    WAITING_FOR_PLAYERS("waiting_for_players", 4, ParticleEmission.SMALL_FLAMES, 200.0, true),
    ACTIVE("active", 8, ParticleEmission.FLAMES_AND_SMOKE, 1000.0, true),
    WAITING_FOR_REWARD_EJECTION("waiting_for_reward_ejection", 8, ParticleEmission.SMALL_FLAMES, -1.0, false),
    EJECTING_REWARD("ejecting_reward", 8, ParticleEmission.SMALL_FLAMES, -1.0, false),
    COOLDOWN("cooldown", 0, ParticleEmission.SMOKE_INSIDE_AND_TOP_FACE, -1.0, false);

    private static final float DELAY_BEFORE_EJECT_AFTER_KILLING_LAST_MOB = 40.0f;
    private static final int TIME_BETWEEN_EACH_EJECTION;
    private final String name;
    private final int lightLevel;
    private final double spinningMobSpeed;
    private final ParticleEmission particleEmission;
    private final boolean isCapableOfSpawning;

    private TrialSpawnerState(String var2, int var3, ParticleEmission var4, double var5, boolean var7) {
        this.name = var2;
        this.lightLevel = var3;
        this.particleEmission = var4;
        this.spinningMobSpeed = var5;
        this.isCapableOfSpawning = var7;
    }

    TrialSpawnerState tickAndGetNext(BlockPos var0, TrialSpawner var1, ServerLevel var2) {
        TrialSpawnerStateData var32 = var1.getStateData();
        TrialSpawnerConfig var42 = var1.activeConfig();
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                if (var32.getOrCreateDisplayEntity(var1, var2, WAITING_FOR_PLAYERS) == null) {
                    yield this;
                }
                yield WAITING_FOR_PLAYERS;
            }
            case 1 -> {
                if (!var1.canSpawnInLevel(var2)) {
                    var32.resetStatistics();
                    yield this;
                }
                if (!var32.hasMobToSpawn(var1, var2.random)) {
                    yield INACTIVE;
                }
                var32.tryDetectPlayers(var2, var0, var1);
                if (var32.detectedPlayers.isEmpty()) {
                    yield this;
                }
                yield ACTIVE;
            }
            case 2 -> {
                if (!var1.canSpawnInLevel(var2)) {
                    var32.resetStatistics();
                    yield WAITING_FOR_PLAYERS;
                }
                if (!var32.hasMobToSpawn(var1, var2.random)) {
                    yield INACTIVE;
                }
                int var5 = var32.countAdditionalPlayers(var0);
                var32.tryDetectPlayers(var2, var0, var1);
                if (var1.isOminous()) {
                    this.spawnOminousOminousItemSpawner(var2, var0, var1);
                }
                if (var32.hasFinishedSpawningAllMobs(var42, var5)) {
                    if (var32.haveAllCurrentMobsDied()) {
                        var32.cooldownEndsAt = var2.getGameTime() + (long)var1.getTargetCooldownLength();
                        var32.totalMobsSpawned = 0;
                        var32.nextMobSpawnsAt = 0L;
                        yield WAITING_FOR_REWARD_EJECTION;
                    }
                } else if (var32.isReadyToSpawnNextMob(var2, var42, var5)) {
                    var1.spawnMob(var2, var0).ifPresent(var4 -> {
                        var0.currentMobs.add((UUID)var4);
                        ++var0.totalMobsSpawned;
                        var0.nextMobSpawnsAt = var2.getGameTime() + (long)var42.ticksBetweenSpawn();
                        var42.spawnPotentialsDefinition().getRandom(var2.getRandom()).ifPresent(var2 -> {
                            var0.nextSpawnData = Optional.of(var2);
                            var1.markUpdated();
                        });
                    });
                }
                yield this;
            }
            case 3 -> {
                if (var32.isReadyToOpenShutter(var2, 40.0f, var1.getTargetCooldownLength())) {
                    var2.playSound(null, var0, SoundEvents.TRIAL_SPAWNER_OPEN_SHUTTER, SoundSource.BLOCKS);
                    yield EJECTING_REWARD;
                }
                yield this;
            }
            case 4 -> {
                if (!var32.isReadyToEjectItems(var2, TIME_BETWEEN_EACH_EJECTION, var1.getTargetCooldownLength())) {
                    yield this;
                }
                if (var32.detectedPlayers.isEmpty()) {
                    var2.playSound(null, var0, SoundEvents.TRIAL_SPAWNER_CLOSE_SHUTTER, SoundSource.BLOCKS);
                    var32.ejectingLootTable = Optional.empty();
                    yield COOLDOWN;
                }
                if (var32.ejectingLootTable.isEmpty()) {
                    var32.ejectingLootTable = var42.lootTablesToEject().getRandom(var2.getRandom());
                }
                var32.ejectingLootTable.ifPresent(var3 -> var1.ejectReward(var2, var0, (ResourceKey<LootTable>)var3));
                var32.detectedPlayers.remove(var32.detectedPlayers.iterator().next());
                yield this;
            }
            case 5 -> {
                var32.tryDetectPlayers(var2, var0, var1);
                if (!var32.detectedPlayers.isEmpty()) {
                    var32.totalMobsSpawned = 0;
                    var32.nextMobSpawnsAt = 0L;
                    yield ACTIVE;
                }
                if (var32.isCooldownFinished(var2)) {
                    var1.removeOminous(var2, var0);
                    var32.reset();
                    yield WAITING_FOR_PLAYERS;
                }
                yield this;
            }
        };
    }

    private void spawnOminousOminousItemSpawner(ServerLevel var0, BlockPos var1, TrialSpawner var2) {
        TrialSpawnerConfig var42;
        TrialSpawnerStateData var3 = var2.getStateData();
        ItemStack var5 = var3.getDispensingItems(var0, var42 = var2.activeConfig(), var1).getRandom(var0.random).orElse(ItemStack.EMPTY);
        if (var5.isEmpty()) {
            return;
        }
        if (this.timeToSpawnItemSpawner(var0, var3)) {
            TrialSpawnerState.calculatePositionToSpawnSpawner(var0, var1, var2, var3).ifPresent(var4 -> {
                OminousItemSpawner var5 = OminousItemSpawner.create(var0, var5);
                var5.snapTo((Vec3)var4);
                var0.addFreshEntity(var5);
                float var6 = (var0.getRandom().nextFloat() - var0.getRandom().nextFloat()) * 0.2f + 1.0f;
                var0.playSound(null, BlockPos.containing(var4), SoundEvents.TRIAL_SPAWNER_SPAWN_ITEM_BEGIN, SoundSource.BLOCKS, 1.0f, var6);
                var2.cooldownEndsAt = var0.getGameTime() + var2.ominousConfig().ticksBetweenItemSpawners();
            });
        }
    }

    private static Optional<Vec3> calculatePositionToSpawnSpawner(ServerLevel var0, BlockPos var1, TrialSpawner var22, TrialSpawnerStateData var3) {
        List<Player> var4 = var3.detectedPlayers.stream().map(var0::getPlayerByUUID).filter(Objects::nonNull).filter(var2 -> !var2.isCreative() && !var2.isSpectator() && var2.isAlive() && var2.distanceToSqr(var1.getCenter()) <= (double)Mth.square(var22.getRequiredPlayerRange())).toList();
        if (var4.isEmpty()) {
            return Optional.empty();
        }
        Entity var5 = TrialSpawnerState.selectEntityToSpawnItemAbove(var4, var3.currentMobs, var22, var1, var0);
        if (var5 == null) {
            return Optional.empty();
        }
        return TrialSpawnerState.calculatePositionAbove(var5, var0);
    }

    private static Optional<Vec3> calculatePositionAbove(Entity var0, ServerLevel var1) {
        Vec3 var3;
        Vec3 var2 = var0.position();
        BlockHitResult var4 = var1.clip(new ClipContext(var2, var3 = var2.relative(Direction.UP, var0.getBbHeight() + 2.0f + (float)var1.random.nextInt(4)), ClipContext.Block.VISUAL, ClipContext.Fluid.NONE, CollisionContext.empty()));
        Vec3 var5 = var4.getBlockPos().getCenter().relative(Direction.DOWN, 1.0);
        BlockPos var6 = BlockPos.containing(var5);
        if (!var1.getBlockState(var6).getCollisionShape(var1, var6).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(var5);
    }

    private static @Nullable Entity selectEntityToSpawnItemAbove(List<Player> var0, Set<UUID> var1, TrialSpawner var22, BlockPos var3, ServerLevel var4) {
        List<Entity> var6;
        Stream<Entity> var5 = var1.stream().map(var4::getEntity).filter(Objects::nonNull).filter(var2 -> var2.isAlive() && var2.distanceToSqr(var3.getCenter()) <= (double)Mth.square(var22.getRequiredPlayerRange()));
        List<Entity> list = var6 = var4.random.nextBoolean() ? var5.toList() : var0;
        if (var6.isEmpty()) {
            return null;
        }
        if (var6.size() == 1) {
            return var6.getFirst();
        }
        return Util.getRandom(var6, var4.random);
    }

    private boolean timeToSpawnItemSpawner(ServerLevel var0, TrialSpawnerStateData var1) {
        return var0.getGameTime() >= var1.cooldownEndsAt;
    }

    public int lightLevel() {
        return this.lightLevel;
    }

    public double spinningMobSpeed() {
        return this.spinningMobSpeed;
    }

    public boolean hasSpinningMob() {
        return this.spinningMobSpeed >= 0.0;
    }

    public boolean isCapableOfSpawning() {
        return this.isCapableOfSpawning;
    }

    public void emitParticles(Level var0, BlockPos var1, boolean var2) {
        this.particleEmission.emit(var0, var0.getRandom(), var1, var2);
    }

    @Override
    public String getSerializedName() {
        return this.name;
    }

    static {
        TIME_BETWEEN_EACH_EJECTION = Mth.floor(30.0f);
    }

    static interface ParticleEmission {
        public static final ParticleEmission NONE = (var0, var1, var2, var3) -> {};
        public static final ParticleEmission SMALL_FLAMES = (var0, var1, var2, var3) -> {
            if (var1.nextInt(2) == 0) {
                Vec3 var4 = var2.getCenter().offsetRandom(var1, 0.9f);
                ParticleEmission.addParticle(var3 ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.SMALL_FLAME, var4, var0);
            }
        };
        public static final ParticleEmission FLAMES_AND_SMOKE = (var0, var1, var2, var3) -> {
            Vec3 var4 = var2.getCenter().offsetRandom(var1, 1.0f);
            ParticleEmission.addParticle(ParticleTypes.SMOKE, var4, var0);
            ParticleEmission.addParticle(var3 ? ParticleTypes.SOUL_FIRE_FLAME : ParticleTypes.FLAME, var4, var0);
        };
        public static final ParticleEmission SMOKE_INSIDE_AND_TOP_FACE = (var0, var1, var2, var3) -> {
            Vec3 var4 = var2.getCenter().offsetRandom(var1, 0.9f);
            if (var1.nextInt(3) == 0) {
                ParticleEmission.addParticle(ParticleTypes.SMOKE, var4, var0);
            }
            if (var0.getGameTime() % 20L == 0L) {
                Vec3 var5 = var2.getCenter().add(0.0, 0.5, 0.0);
                int var6 = var0.getRandom().nextInt(4) + 20;
                for (int var7 = 0; var7 < var6; ++var7) {
                    ParticleEmission.addParticle(ParticleTypes.SMOKE, var5, var0);
                }
            }
        };

        private static void addParticle(SimpleParticleType var0, Vec3 var1, Level var2) {
            var2.addParticle(var0, var1.x(), var1.y(), var1.z(), 0.0, 0.0, 0.0);
        }

        public void emit(Level var1, RandomSource var2, BlockPos var3, boolean var4);
    }

    static class LightLevel {
        private static final int UNLIT = 0;
        private static final int HALF_LIT = 4;
        private static final int LIT = 8;

        private LightLevel() {
        }
    }

    static class SpinningMob {
        private static final double NONE = -1.0;
        private static final double SLOW = 200.0;
        private static final double FAST = 1000.0;

        private SpinningMob() {
        }
    }
}

