/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class MovingPistonBlock
extends BaseEntityBlock {
    public static final MapCodec<MovingPistonBlock> CODEC = MovingPistonBlock.simpleCodec(MovingPistonBlock::new);
    public static final EnumProperty<Direction> FACING = PistonHeadBlock.FACING;
    public static final EnumProperty<PistonType> TYPE = PistonHeadBlock.TYPE;

    public MapCodec<MovingPistonBlock> codec() {
        return CODEC;
    }

    public MovingPistonBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(TYPE, PistonType.DEFAULT));
    }

    @Override
    public @Nullable BlockEntity newBlockEntity(BlockPos var0, BlockState var1) {
        return null;
    }

    public static BlockEntity newMovingBlockEntity(BlockPos var0, BlockState var1, BlockState var2, Direction var3, boolean var4, boolean var5) {
        return new PistonMovingBlockEntity(var0, var1, var2, var3, var4, var5);
    }

    @Override
    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> getTicker(Level var0, BlockState var1, BlockEntityType<T> var2) {
        return MovingPistonBlock.createTickerHelper(var2, BlockEntityType.PISTON, PistonMovingBlockEntity::tick);
    }

    @Override
    public void destroy(LevelAccessor var0, BlockPos var1, BlockState var2) {
        BlockPos var3 = var1.relative(var2.getValue(FACING).getOpposite());
        BlockState var4 = var0.getBlockState(var3);
        if (var4.getBlock() instanceof PistonBaseBlock && var4.getValue(PistonBaseBlock.EXTENDED).booleanValue()) {
            var0.removeBlock(var3, false);
        }
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState var0, Level var1, BlockPos var2, Player var3, BlockHitResult var4) {
        if (!var1.isClientSide() && var1.getBlockEntity(var2) == null) {
            var1.removeBlock(var2, false);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected List<ItemStack> getDrops(BlockState var0, LootParams.Builder var1) {
        PistonMovingBlockEntity var2 = this.getBlockEntity(var1.getLevel(), BlockPos.containing(var1.getParameter(LootContextParams.ORIGIN)));
        if (var2 == null) {
            return Collections.emptyList();
        }
        return var2.getMovedState().getDrops(var1);
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return Shapes.empty();
    }

    @Override
    protected VoxelShape getCollisionShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        PistonMovingBlockEntity var4 = this.getBlockEntity(var1, var2);
        if (var4 != null) {
            return var4.getCollisionShape(var1, var2);
        }
        return Shapes.empty();
    }

    private @Nullable PistonMovingBlockEntity getBlockEntity(BlockGetter var0, BlockPos var1) {
        BlockEntity var2 = var0.getBlockEntity(var1);
        if (var2 instanceof PistonMovingBlockEntity) {
            return (PistonMovingBlockEntity)var2;
        }
        return null;
    }

    @Override
    protected RenderShape getRenderShape(BlockState var0) {
        return RenderShape.INVISIBLE;
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader var0, BlockPos var1, BlockState var2, boolean var3) {
        return ItemStack.EMPTY;
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate(var0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation(var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, TYPE);
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }
}

