/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.mojang.serialization.MapCodec;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jspecify.annotations.Nullable;

public class PistonHeadBlock
extends DirectionalBlock {
    public static final MapCodec<PistonHeadBlock> CODEC = PistonHeadBlock.simpleCodec(PistonHeadBlock::new);
    public static final EnumProperty<PistonType> TYPE = BlockStateProperties.PISTON_TYPE;
    public static final BooleanProperty SHORT = BlockStateProperties.SHORT;
    public static final int PLATFORM_THICKNESS = 4;
    private static final VoxelShape SHAPE_PLATFORM = Block.boxZ(16.0, 0.0, 4.0);
    private static final Map<Direction, VoxelShape> SHAPES_SHORT = Shapes.rotateAll(Shapes.or(SHAPE_PLATFORM, Block.boxZ(4.0, 4.0, 16.0)));
    private static final Map<Direction, VoxelShape> SHAPES = Shapes.rotateAll(Shapes.or(SHAPE_PLATFORM, Block.boxZ(4.0, 4.0, 20.0)));

    protected MapCodec<PistonHeadBlock> codec() {
        return CODEC;
    }

    public PistonHeadBlock(BlockBehaviour.Properties var0) {
        super(var0);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, Direction.NORTH)).setValue(TYPE, PistonType.DEFAULT)).setValue(SHORT, false));
    }

    @Override
    protected boolean useShapeForLightOcclusion(BlockState var0) {
        return true;
    }

    @Override
    protected VoxelShape getShape(BlockState var0, BlockGetter var1, BlockPos var2, CollisionContext var3) {
        return (var0.getValue(SHORT) != false ? SHAPES_SHORT : SHAPES).get(var0.getValue(FACING));
    }

    private boolean isFittingBase(BlockState var0, BlockState var1) {
        Block var2 = var0.getValue(TYPE) == PistonType.DEFAULT ? Blocks.PISTON : Blocks.STICKY_PISTON;
        return var1.is(var2) && var1.getValue(PistonBaseBlock.EXTENDED) != false && var1.getValue(FACING) == var0.getValue(FACING);
    }

    @Override
    public BlockState playerWillDestroy(Level var0, BlockPos var1, BlockState var2, Player var3) {
        BlockPos var4;
        if (!var0.isClientSide() && var3.preventsBlockDrops() && this.isFittingBase(var2, var0.getBlockState(var4 = var1.relative(((Direction)var2.getValue(FACING)).getOpposite())))) {
            var0.destroyBlock(var4, false);
        }
        return super.playerWillDestroy(var0, var1, var2, var3);
    }

    @Override
    protected void affectNeighborsAfterRemoval(BlockState var0, ServerLevel var1, BlockPos var2, boolean var3) {
        BlockPos var4 = var2.relative(((Direction)var0.getValue(FACING)).getOpposite());
        if (this.isFittingBase(var0, var1.getBlockState(var4))) {
            var1.destroyBlock(var4, true);
        }
    }

    @Override
    protected BlockState updateShape(BlockState var0, LevelReader var1, ScheduledTickAccess var2, BlockPos var3, Direction var4, BlockPos var5, BlockState var6, RandomSource var7) {
        if (var4.getOpposite() == var0.getValue(FACING) && !var0.canSurvive(var1, var3)) {
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(var0, var1, var2, var3, var4, var5, var6, var7);
    }

    @Override
    protected boolean canSurvive(BlockState var0, LevelReader var1, BlockPos var2) {
        BlockState var3 = var1.getBlockState(var2.relative(((Direction)var0.getValue(FACING)).getOpposite()));
        return this.isFittingBase(var0, var3) || var3.is(Blocks.MOVING_PISTON) && var3.getValue(FACING) == var0.getValue(FACING);
    }

    @Override
    protected void neighborChanged(BlockState var0, Level var1, BlockPos var2, Block var3, @Nullable Orientation var4, boolean var5) {
        if (var0.canSurvive(var1, var2)) {
            var1.neighborChanged(var2.relative(((Direction)var0.getValue(FACING)).getOpposite()), var3, ExperimentalRedstoneUtils.withFront(var4, ((Direction)var0.getValue(FACING)).getOpposite()));
        }
    }

    @Override
    protected ItemStack getCloneItemStack(LevelReader var0, BlockPos var1, BlockState var2, boolean var3) {
        return new ItemStack(var2.getValue(TYPE) == PistonType.STICKY ? Blocks.STICKY_PISTON : Blocks.PISTON);
    }

    @Override
    protected BlockState rotate(BlockState var0, Rotation var1) {
        return (BlockState)var0.setValue(FACING, var1.rotate((Direction)var0.getValue(FACING)));
    }

    @Override
    protected BlockState mirror(BlockState var0, Mirror var1) {
        return var0.rotate(var1.getRotation((Direction)var0.getValue(FACING)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> var0) {
        var0.add(FACING, TYPE, SHORT);
    }

    @Override
    protected boolean isPathfindable(BlockState var0, PathComputationType var1) {
        return false;
    }
}

