/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapDecoder;
import com.mojang.serialization.MapEncoder;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.Nullable;

public class StateDefinition<O, S extends StateHolder<O, S>> {
    static final Pattern NAME_PATTERN = Pattern.compile("^[a-z0-9_]+$");
    private final O owner;
    private final ImmutableSortedMap<String, Property<?>> propertiesByName;
    private final ImmutableList<S> states;

    protected StateDefinition(Function<O, S> var0, O var1, Factory<O, S> var2, Map<String, Property<?>> var3) {
        Object var72;
        this.owner = var1;
        this.propertiesByName = ImmutableSortedMap.copyOf(var3);
        Supplier<StateHolder> var4 = () -> (StateHolder)var0.apply(var1);
        MapCodec<StateHolder> var5 = MapCodec.of((MapEncoder)Encoder.empty(), (MapDecoder)Decoder.unit(var4));
        for (Object var72 : this.propertiesByName.entrySet()) {
            var5 = StateDefinition.appendPropertyCodec(var5, var4, (String)var72.getKey(), (Property)var72.getValue());
        }
        MapCodec<StateHolder> var6 = var5;
        var72 = Maps.newLinkedHashMap();
        ArrayList var8 = Lists.newArrayList();
        Stream<List<List<Object>>> var9 = Stream.of(Collections.emptyList());
        for (Object var11 : this.propertiesByName.values()) {
            var9 = var9.flatMap(arg_0 -> StateDefinition.lambda$new$2((Property)var11, arg_0));
        }
        var9.forEach(arg_0 -> StateDefinition.lambda$new$3(var2, var1, var6, (Map)var72, var8, arg_0));
        for (Object var11 : var8) {
            ((StateHolder)var11).populateNeighbours(var72);
        }
        this.states = ImmutableList.copyOf((Collection)var8);
    }

    private static <S extends StateHolder<?, S>, T extends Comparable<T>> MapCodec<S> appendPropertyCodec(MapCodec<S> var02, Supplier<S> var12, String var2, Property<T> var3) {
        return Codec.mapPair(var02, (MapCodec)var3.valueCodec().fieldOf(var2).orElseGet(var0 -> {}, () -> var3.value((StateHolder)var12.get()))).xmap(var1 -> (StateHolder)((StateHolder)var1.getFirst()).setValue(var3, ((Property.Value)var1.getSecond()).value()), var1 -> Pair.of((Object)var1, var3.value((StateHolder<?, ?>)var1)));
    }

    public ImmutableList<S> getPossibleStates() {
        return this.states;
    }

    public S any() {
        return (S)((StateHolder)this.states.get(0));
    }

    public O getOwner() {
        return this.owner;
    }

    public Collection<Property<?>> getProperties() {
        return this.propertiesByName.values();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("block", this.owner).add("properties", this.propertiesByName.values().stream().map(Property::getName).collect(Collectors.toList())).toString();
    }

    public @Nullable Property<?> getProperty(String var0) {
        return (Property)this.propertiesByName.get((Object)var0);
    }

    private static /* synthetic */ void lambda$new$3(Factory var0, Object var1, MapCodec var2, Map var3, List var4, List var5) {
        Reference2ObjectArrayMap var6 = new Reference2ObjectArrayMap(var5.size());
        for (Pair var8 : var5) {
            var6.put((Object)((Property)var8.getFirst()), (Object)((Comparable)var8.getSecond()));
        }
        StateHolder var7 = (StateHolder)var0.create(var1, var6, var2);
        var3.put(var6, var7);
        var4.add(var7);
    }

    private static /* synthetic */ Stream lambda$new$2(Property var0, List var1) {
        return var0.getPossibleValues().stream().map(var2 -> {
            ArrayList var3 = Lists.newArrayList((Iterable)var1);
            var3.add(Pair.of((Object)var0, (Object)var2));
            return var3;
        });
    }

    public static interface Factory<O, S> {
        public S create(O var1, Reference2ObjectArrayMap<Property<?>, Comparable<?>> var2, MapCodec<S> var3);
    }

    public static class Builder<O, S extends StateHolder<O, S>> {
        private final O owner;
        private final Map<String, Property<?>> properties = Maps.newHashMap();

        public Builder(O var0) {
            this.owner = var0;
        }

        public Builder<O, S> add(Property<?> ... var0) {
            for (Property<?> var4 : var0) {
                this.validateProperty(var4);
                this.properties.put(var4.getName(), var4);
            }
            return this;
        }

        private <T extends Comparable<T>> void validateProperty(Property<T> var0) {
            String var1 = var0.getName();
            if (!NAME_PATTERN.matcher(var1).matches()) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has invalidly named property: " + var1);
            }
            List<T> var2 = var0.getPossibleValues();
            if (var2.size() <= 1) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " attempted use property " + var1 + " with <= 1 possible values");
            }
            for (Comparable var4 : var2) {
                String var5 = var0.getName(var4);
                if (NAME_PATTERN.matcher(var5).matches()) continue;
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has property: " + var1 + " with invalidly named value: " + var5);
            }
            if (this.properties.containsKey(var1)) {
                throw new IllegalArgumentException(String.valueOf(this.owner) + " has duplicate property: " + var1);
            }
        }

        public StateDefinition<O, S> create(Function<O, S> var0, Factory<O, S> var1) {
            return new StateDefinition<O, S>(var0, this.owner, var1, this.properties);
        }
    }
}

