/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.predicate;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jspecify.annotations.Nullable;

public class BlockStatePredicate
implements Predicate<BlockState> {
    public static final Predicate<BlockState> ANY = var0 -> true;
    private final StateDefinition<Block, BlockState> definition;
    private final Map<Property<?>, Predicate<Object>> properties = Maps.newHashMap();

    private BlockStatePredicate(StateDefinition<Block, BlockState> var0) {
        this.definition = var0;
    }

    public static BlockStatePredicate forBlock(Block var0) {
        return new BlockStatePredicate(var0.getStateDefinition());
    }

    @Override
    public boolean test(@Nullable BlockState var0) {
        if (var0 == null || !var0.getBlock().equals(this.definition.getOwner())) {
            return false;
        }
        if (this.properties.isEmpty()) {
            return true;
        }
        for (Map.Entry<Property<?>, Predicate<Object>> var2 : this.properties.entrySet()) {
            if (this.applies(var0, var2.getKey(), var2.getValue())) continue;
            return false;
        }
        return true;
    }

    protected <T extends Comparable<T>> boolean applies(BlockState var0, Property<T> var1, Predicate<Object> var2) {
        T var3 = var0.getValue(var1);
        return var2.test(var3);
    }

    public <V extends Comparable<V>> BlockStatePredicate where(Property<V> var0, Predicate<Object> var1) {
        if (!this.definition.getProperties().contains(var0)) {
            throw new IllegalArgumentException(String.valueOf(this.definition) + " cannot support property " + String.valueOf(var0));
        }
        this.properties.put(var0, var1);
        return this;
    }

    @Override
    public /* synthetic */ boolean test(@Nullable Object object) {
        return this.test((BlockState)object);
    }
}

