/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.jspecify.annotations.Nullable;

public class BulkSectionAccess
implements AutoCloseable {
    private final LevelAccessor level;
    private final Long2ObjectMap<LevelChunkSection> acquiredSections = new Long2ObjectOpenHashMap();
    private @Nullable LevelChunkSection lastSection;
    private long lastSectionKey;

    public BulkSectionAccess(LevelAccessor var0) {
        this.level = var0;
    }

    public @Nullable LevelChunkSection getSection(BlockPos var0) {
        int var1 = this.level.getSectionIndex(var0.getY());
        if (var1 < 0 || var1 >= this.level.getSectionsCount()) {
            return null;
        }
        long var22 = SectionPos.asLong(var0);
        if (this.lastSection == null || this.lastSectionKey != var22) {
            this.lastSection = (LevelChunkSection)this.acquiredSections.computeIfAbsent(var22, var2 -> {
                ChunkAccess var4 = this.level.getChunk(SectionPos.blockToSectionCoord(var0.getX()), SectionPos.blockToSectionCoord(var0.getZ()));
                LevelChunkSection var5 = var4.getSection(var1);
                var5.acquire();
                return var5;
            });
            this.lastSectionKey = var22;
        }
        return this.lastSection;
    }

    public BlockState getBlockState(BlockPos var0) {
        LevelChunkSection var1 = this.getSection(var0);
        if (var1 == null) {
            return Blocks.AIR.defaultBlockState();
        }
        int var2 = SectionPos.sectionRelative(var0.getX());
        int var3 = SectionPos.sectionRelative(var0.getY());
        int var4 = SectionPos.sectionRelative(var0.getZ());
        return var1.getBlockState(var2, var3, var4);
    }

    @Override
    public void close() {
        for (LevelChunkSection var1 : this.acquiredSections.values()) {
            var1.release();
        }
    }
}

