/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import org.apache.commons.lang3.Validate;
import org.jspecify.annotations.Nullable;

public class SingleValuePalette<T>
implements Palette<T> {
    private @Nullable T value;

    public SingleValuePalette(List<T> var0) {
        if (!var0.isEmpty()) {
            Validate.isTrue((var0.size() <= 1 ? 1 : 0) != 0, (String)"Can't initialize SingleValuePalette with %d values.", (long)var0.size());
            this.value = var0.getFirst();
        }
    }

    public static <A> Palette<A> create(int var0, List<A> var1) {
        return new SingleValuePalette<A>(var1);
    }

    @Override
    public int idFor(T var0, PaletteResize<T> var1) {
        if (this.value == null || this.value == var0) {
            this.value = var0;
            return 0;
        }
        return var1.onResize(1, var0);
    }

    @Override
    public boolean maybeHas(Predicate<T> var0) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return var0.test(this.value);
    }

    @Override
    public T valueFor(int var0) {
        if (this.value == null || var0 != 0) {
            throw new IllegalStateException("Missing Palette entry for id " + var0 + ".");
        }
        return this.value;
    }

    @Override
    public void read(FriendlyByteBuf var0, IdMap<T> var1) {
        this.value = var1.byIdOrThrow(var0.readVarInt());
    }

    @Override
    public void write(FriendlyByteBuf var0, IdMap<T> var1) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        var0.writeVarInt(var1.getId(this.value));
    }

    @Override
    public int getSerializedSize(IdMap<T> var0) {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return VarInt.getByteSize(var0.getId(this.value));
    }

    @Override
    public int getSize() {
        return 1;
    }

    @Override
    public Palette<T> copy() {
        if (this.value == null) {
            throw new IllegalStateException("Use of an uninitialized palette");
        }
        return this;
    }
}

