/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.BitSet;

public class RegionBitmap {
    private final BitSet used = new BitSet();

    public void force(int var0, int var1) {
        this.used.set(var0, var0 + var1);
    }

    public void free(int var0, int var1) {
        this.used.clear(var0, var0 + var1);
    }

    public int allocate(int var0) {
        int var1 = 0;
        while (true) {
            int var2;
            int var3;
            if ((var3 = this.used.nextSetBit(var2 = this.used.nextClearBit(var1))) == -1 || var3 - var2 >= var0) {
                this.force(var2, var0);
                return var2;
            }
            var1 = var3;
        }
    }

    @VisibleForTesting
    public IntSet getUsed() {
        return (IntSet)this.used.stream().collect(IntArraySet::new, IntCollection::add, IntCollection::addAll);
    }
}

