/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.ChunkScanAccess;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.LegacyTagFixer;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import org.jspecify.annotations.Nullable;
import org.spigotmc.SpigotConfig;

public class SimpleRegionStorage
implements AutoCloseable {
    private final IOWorker worker;
    private final DataFixer fixerUpper;
    private final DataFixTypes dataFixType;
    private final Supplier<LegacyTagFixer> legacyFixer;

    public SimpleRegionStorage(RegionStorageInfo regionstorageinfo, Path path, DataFixer datafixer, boolean flag, DataFixTypes datafixtypes) {
        this(regionstorageinfo, path, datafixer, flag, datafixtypes, LegacyTagFixer.EMPTY);
    }

    public SimpleRegionStorage(RegionStorageInfo regionstorageinfo, Path path, DataFixer datafixer, boolean flag, DataFixTypes datafixtypes, Supplier<LegacyTagFixer> supplier) {
        this.fixerUpper = datafixer;
        this.dataFixType = datafixtypes;
        this.worker = new IOWorker(regionstorageinfo, path, flag);
        Objects.requireNonNull(supplier);
        this.legacyFixer = Suppliers.memoize(supplier::get);
    }

    public boolean isOldChunkAround(ChunkPos chunkcoordintpair, int i) {
        return this.worker.isOldChunkAround(chunkcoordintpair, i);
    }

    public CompletableFuture<Optional<CompoundTag>> read(ChunkPos chunkcoordintpair) {
        return this.worker.loadAsync(chunkcoordintpair);
    }

    public CompletableFuture<Void> write(ChunkPos chunkcoordintpair, CompoundTag nbttagcompound) {
        return this.write(chunkcoordintpair, () -> nbttagcompound);
    }

    public CompletableFuture<Void> write(ChunkPos chunkcoordintpair, Supplier<CompoundTag> supplier) {
        this.markChunkDone(chunkcoordintpair);
        return this.worker.store(chunkcoordintpair, supplier);
    }

    private boolean check(ServerChunkCache cps, int x, int z) {
        CompoundTag nbt;
        ChunkPos pos = new ChunkPos(x, z);
        if (cps != null && cps.hasChunk(x, z)) {
            return true;
        }
        try {
            nbt = this.read(pos).get().orElse(null);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new RuntimeException(ex);
        }
        if (nbt != null) {
            CompoundTag level = nbt.getCompoundOrEmpty("Level");
            if (level.getBooleanOr("TerrainPopulated", false)) {
                return true;
            }
            ChunkStatus status = ChunkStatus.byName(level.getStringOr("Status", ""));
            if (status != null && status.isOrAfter(ChunkStatus.FEATURES)) {
                return true;
            }
        }
        return false;
    }

    public CompoundTag upgradeChunkTag(CompoundTag nbttagcompound, int i, @Nullable CompoundTag nbttagcompound1) {
        return this.upgradeChunkTag(nbttagcompound, i, nbttagcompound1, null, null);
    }

    public CompoundTag upgradeChunkTag(CompoundTag nbttagcompound, int i, @Nullable CompoundTag nbttagcompound1, ChunkPos pos, @Nullable LevelAccessor generatoraccess) {
        int j = NbtUtils.getDataVersion(nbttagcompound, i);
        if (j == SharedConstants.getCurrentVersion().dataVersion().version()) {
            return nbttagcompound;
        }
        try {
            boolean belowZeroGenerationInExistingChunks;
            CompoundTag level;
            if (j < 1466 && pos != null && (level = nbttagcompound.getCompoundOrEmpty("Level")).getBooleanOr("TerrainPopulated", false) && !level.getBooleanOr("LightPopulated", false)) {
                ServerChunkCache cps;
                ServerChunkCache serverChunkCache = cps = generatoraccess == null ? null : ((ServerLevel)generatoraccess).getChunkSource();
                if (this.check(cps, pos.x - 1, pos.z) && this.check(cps, pos.x - 1, pos.z - 1) && this.check(cps, pos.x, pos.z - 1)) {
                    level.putBoolean("LightPopulated", true);
                }
            }
            boolean stopBelowZero = false;
            boolean bl = belowZeroGenerationInExistingChunks = generatoraccess != null ? ((ServerLevel)generatoraccess).spigotConfig.belowZeroGenerationInExistingChunks : SpigotConfig.belowZeroGenerationInExistingChunks;
            if (i <= 2730 && !belowZeroGenerationInExistingChunks) {
                stopBelowZero = "full".equals(nbttagcompound.getCompoundOrEmpty("Level").getStringOr("Status", ""));
            }
            nbttagcompound = this.legacyFixer.get().applyFix(nbttagcompound);
            SimpleRegionStorage.injectDatafixingContext(nbttagcompound, nbttagcompound1);
            nbttagcompound = this.dataFixType.updateToCurrentVersion(this.fixerUpper, nbttagcompound, Math.max(this.legacyFixer.get().targetDataVersion(), j));
            if (stopBelowZero) {
                nbttagcompound.putString("Status", BuiltInRegistries.CHUNK_STATUS.getKey(ChunkStatus.SPAWN).toString());
            }
            SimpleRegionStorage.removeDatafixingContext(nbttagcompound);
            NbtUtils.addCurrentDataVersion(nbttagcompound);
            return nbttagcompound;
        }
        catch (Exception exception) {
            CrashReport crashreport = CrashReport.forThrowable(exception, "Updated chunk");
            CrashReportCategory crashreportsystemdetails = crashreport.addCategory("Updated chunk details");
            crashreportsystemdetails.setDetail("Data version", j);
            throw new ReportedException(crashreport);
        }
    }

    public CompoundTag upgradeChunkTag(CompoundTag nbttagcompound, int i) {
        return this.upgradeChunkTag(nbttagcompound, i, null);
    }

    public Dynamic<Tag> upgradeChunkTag(Dynamic<Tag> dynamic, int i) {
        return new Dynamic(dynamic.getOps(), (Object)this.upgradeChunkTag((CompoundTag)dynamic.getValue(), i, null));
    }

    public static void injectDatafixingContext(CompoundTag nbttagcompound, @Nullable CompoundTag nbttagcompound1) {
        if (nbttagcompound1 != null) {
            nbttagcompound.put("__context", nbttagcompound1);
        }
    }

    private static void removeDatafixingContext(CompoundTag nbttagcompound) {
        nbttagcompound.remove("__context");
    }

    protected void markChunkDone(ChunkPos chunkcoordintpair) {
        this.legacyFixer.get().markChunkDone(chunkcoordintpair);
    }

    public CompletableFuture<Void> synchronize(boolean flag) {
        return this.worker.synchronize(flag);
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }

    public ChunkScanAccess chunkScanner() {
        return this.worker;
    }

    public RegionStorageInfo storageInfo() {
        return this.worker.storageInfo();
    }
}

