/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.level.levelgen.Heightmap;
import org.bukkit.event.entity.CreatureSpawnEvent;

public class PatrolSpawner
implements CustomSpawner {
    private int nextTick;

    @Override
    public void tick(ServerLevel worldserver, boolean flag) {
        if (flag && worldserver.getGameRules().get(GameRules.SPAWN_PATROLS).booleanValue()) {
            RandomSource randomsource = worldserver.random;
            --this.nextTick;
            if (this.nextTick <= 0) {
                Player entityhuman;
                int i;
                this.nextTick += 12000 + randomsource.nextInt(1200);
                if (worldserver.isBrightOutside() && randomsource.nextInt(5) == 0 && (i = worldserver.players().size()) >= 1 && !(entityhuman = (Player)worldserver.players().get(randomsource.nextInt(i))).isSpectator() && !worldserver.isCloseToVillage(entityhuman.blockPosition(), 2)) {
                    int j = (24 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
                    int k = (24 + randomsource.nextInt(24)) * (randomsource.nextBoolean() ? -1 : 1);
                    BlockPos.MutableBlockPos blockposition_mutableblockposition = entityhuman.blockPosition().mutable().move(j, 0, k);
                    int l = 10;
                    if (worldserver.hasChunksAt(blockposition_mutableblockposition.getX() - 10, blockposition_mutableblockposition.getZ() - 10, blockposition_mutableblockposition.getX() + 10, blockposition_mutableblockposition.getZ() + 10) && worldserver.environmentAttributes().getValue(EnvironmentAttributes.CAN_PILLAGER_PATROL_SPAWN, blockposition_mutableblockposition).booleanValue()) {
                        int i1 = (int)Math.ceil(worldserver.getCurrentDifficultyAt(blockposition_mutableblockposition).getEffectiveDifficulty()) + 1;
                        for (int j1 = 0; j1 < i1; ++j1) {
                            blockposition_mutableblockposition.setY(worldserver.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockposition_mutableblockposition).getY());
                            if (j1 == 0) {
                                if (!this.spawnPatrolMember(worldserver, blockposition_mutableblockposition, randomsource, true)) {
                                    break;
                                }
                            } else {
                                this.spawnPatrolMember(worldserver, blockposition_mutableblockposition, randomsource, false);
                            }
                            blockposition_mutableblockposition.setX(blockposition_mutableblockposition.getX() + randomsource.nextInt(5) - randomsource.nextInt(5));
                            blockposition_mutableblockposition.setZ(blockposition_mutableblockposition.getZ() + randomsource.nextInt(5) - randomsource.nextInt(5));
                        }
                    }
                }
            }
        }
    }

    private boolean spawnPatrolMember(ServerLevel worldserver, BlockPos blockposition, RandomSource randomsource, boolean flag) {
        BlockState iblockdata = worldserver.getBlockState(blockposition);
        if (!NaturalSpawner.isValidEmptySpawnBlock(worldserver, blockposition, iblockdata, iblockdata.getFluidState(), EntityType.PILLAGER)) {
            return false;
        }
        if (!PatrollingMonster.checkPatrollingMonsterSpawnRules(EntityType.PILLAGER, worldserver, EntitySpawnReason.PATROL, blockposition, randomsource)) {
            return false;
        }
        PatrollingMonster entitymonsterpatrolling = EntityType.PILLAGER.create(worldserver, EntitySpawnReason.PATROL);
        if (entitymonsterpatrolling != null) {
            if (flag) {
                entitymonsterpatrolling.setPatrolLeader(true);
                entitymonsterpatrolling.findPatrolTarget();
            }
            entitymonsterpatrolling.setPos(blockposition.getX(), blockposition.getY(), blockposition.getZ());
            entitymonsterpatrolling.finalizeSpawn(worldserver, worldserver.getCurrentDifficultyAt(blockposition), EntitySpawnReason.PATROL, null);
            worldserver.addFreshEntityWithPassengers(entitymonsterpatrolling, CreatureSpawnEvent.SpawnReason.PATROL);
            return true;
        }
        return false;
    }
}

