/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.BlockColumn;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class SurfaceSystem {
    private static final BlockState WHITE_TERRACOTTA = Blocks.WHITE_TERRACOTTA.defaultBlockState();
    private static final BlockState ORANGE_TERRACOTTA = Blocks.ORANGE_TERRACOTTA.defaultBlockState();
    private static final BlockState TERRACOTTA = Blocks.TERRACOTTA.defaultBlockState();
    private static final BlockState YELLOW_TERRACOTTA = Blocks.YELLOW_TERRACOTTA.defaultBlockState();
    private static final BlockState BROWN_TERRACOTTA = Blocks.BROWN_TERRACOTTA.defaultBlockState();
    private static final BlockState RED_TERRACOTTA = Blocks.RED_TERRACOTTA.defaultBlockState();
    private static final BlockState LIGHT_GRAY_TERRACOTTA = Blocks.LIGHT_GRAY_TERRACOTTA.defaultBlockState();
    private static final BlockState PACKED_ICE = Blocks.PACKED_ICE.defaultBlockState();
    private static final BlockState SNOW_BLOCK = Blocks.SNOW_BLOCK.defaultBlockState();
    private final BlockState defaultBlock;
    private final int seaLevel;
    private final BlockState[] clayBands;
    private final NormalNoise clayBandsOffsetNoise;
    private final NormalNoise badlandsPillarNoise;
    private final NormalNoise badlandsPillarRoofNoise;
    private final NormalNoise badlandsSurfaceNoise;
    private final NormalNoise icebergPillarNoise;
    private final NormalNoise icebergPillarRoofNoise;
    private final NormalNoise icebergSurfaceNoise;
    private final PositionalRandomFactory noiseRandom;
    private final NormalNoise surfaceNoise;
    private final NormalNoise surfaceSecondaryNoise;

    public SurfaceSystem(RandomState var0, BlockState var1, int var2, PositionalRandomFactory var3) {
        this.defaultBlock = var1;
        this.seaLevel = var2;
        this.noiseRandom = var3;
        this.clayBandsOffsetNoise = var0.getOrCreateNoise(Noises.CLAY_BANDS_OFFSET);
        this.clayBands = SurfaceSystem.generateBands(var3.fromHashOf(Identifier.withDefaultNamespace("clay_bands")));
        this.surfaceNoise = var0.getOrCreateNoise(Noises.SURFACE);
        this.surfaceSecondaryNoise = var0.getOrCreateNoise(Noises.SURFACE_SECONDARY);
        this.badlandsPillarNoise = var0.getOrCreateNoise(Noises.BADLANDS_PILLAR);
        this.badlandsPillarRoofNoise = var0.getOrCreateNoise(Noises.BADLANDS_PILLAR_ROOF);
        this.badlandsSurfaceNoise = var0.getOrCreateNoise(Noises.BADLANDS_SURFACE);
        this.icebergPillarNoise = var0.getOrCreateNoise(Noises.ICEBERG_PILLAR);
        this.icebergPillarRoofNoise = var0.getOrCreateNoise(Noises.ICEBERG_PILLAR_ROOF);
        this.icebergSurfaceNoise = var0.getOrCreateNoise(Noises.ICEBERG_SURFACE);
    }

    public void buildSurface(RandomState var0, BiomeManager var1, Registry<Biome> var2, boolean var3, WorldGenerationContext var4, final ChunkAccess var5, NoiseChunk var6, SurfaceRules.RuleSource var7) {
        final BlockPos.MutableBlockPos var8 = new BlockPos.MutableBlockPos();
        final ChunkPos var9 = var5.getPos();
        int var10 = var9.getMinBlockX();
        int var11 = var9.getMinBlockZ();
        BlockColumn var12 = new BlockColumn(this){

            @Override
            public BlockState getBlock(int var0) {
                return var5.getBlockState(var8.setY(var0));
            }

            @Override
            public void setBlock(int var0, BlockState var1) {
                LevelHeightAccessor var2 = var5.getHeightAccessorForGeneration();
                if (var2.isInsideBuildHeight(var0)) {
                    var5.setBlockState(var8.setY(var0), var1);
                    if (!var1.getFluidState().isEmpty()) {
                        var5.markPosForPostprocessing(var8);
                    }
                }
            }

            public String toString() {
                return "ChunkBlockColumn " + String.valueOf(var9);
            }
        };
        SurfaceRules.Context var13 = new SurfaceRules.Context(this, var0, var5, var6, var1::getBiome, var2, var4);
        SurfaceRules.SurfaceRule var14 = (SurfaceRules.SurfaceRule)var7.apply(var13);
        BlockPos.MutableBlockPos var15 = new BlockPos.MutableBlockPos();
        for (int var16 = 0; var16 < 16; ++var16) {
            for (int var17 = 0; var17 < 16; ++var17) {
                int var18 = var10 + var16;
                int var19 = var11 + var17;
                int var20 = var5.getHeight(Heightmap.Types.WORLD_SURFACE_WG, var16, var17) + 1;
                var8.setX(var18).setZ(var19);
                Holder<Biome> var21 = var1.getBiome(var15.set(var18, var3 ? 0 : var20, var19));
                if (var21.is(Biomes.ERODED_BADLANDS)) {
                    this.erodedBadlandsExtension(var12, var18, var19, var20, var5);
                }
                int var22 = var5.getHeight(Heightmap.Types.WORLD_SURFACE_WG, var16, var17) + 1;
                var13.updateXZ(var18, var19);
                int var23 = 0;
                int var24 = Integer.MIN_VALUE;
                int var25 = Integer.MAX_VALUE;
                int var26 = var5.getMinY();
                for (int var27 = var22; var27 >= var26; --var27) {
                    BlockState var30;
                    int var29;
                    BlockState var28 = var12.getBlock(var27);
                    if (var28.isAir()) {
                        var23 = 0;
                        var24 = Integer.MIN_VALUE;
                        continue;
                    }
                    if (!var28.getFluidState().isEmpty()) {
                        if (var24 != Integer.MIN_VALUE) continue;
                        var24 = var27 + 1;
                        continue;
                    }
                    if (var25 >= var27) {
                        var25 = DimensionType.WAY_BELOW_MIN_Y;
                        for (var29 = var27 - 1; var29 >= var26 - 1; --var29) {
                            var30 = var12.getBlock(var29);
                            if (this.isStone(var30)) continue;
                            var25 = var29 + 1;
                            break;
                        }
                    }
                    var29 = var27 - var25 + 1;
                    var13.updateY(++var23, var29, var24, var18, var27, var19);
                    if (var28 != this.defaultBlock || (var30 = var14.tryApply(var18, var27, var19)) == null) continue;
                    var12.setBlock(var27, var30);
                }
                if (!var21.is(Biomes.FROZEN_OCEAN) && !var21.is(Biomes.DEEP_FROZEN_OCEAN)) continue;
                this.frozenOceanExtension(var13.getMinSurfaceLevel(), var21.value(), var12, var15, var18, var19, var20);
            }
        }
    }

    protected int getSurfaceDepth(int var0, int var1) {
        double var2 = this.surfaceNoise.getValue(var0, 0.0, var1);
        return (int)(var2 * 2.75 + 3.0 + this.noiseRandom.at(var0, 0, var1).nextDouble() * 0.25);
    }

    protected double getSurfaceSecondary(int var0, int var1) {
        return this.surfaceSecondaryNoise.getValue(var0, 0.0, var1);
    }

    private boolean isStone(BlockState var0) {
        return !var0.isAir() && var0.getFluidState().isEmpty();
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    @Deprecated
    public Optional<BlockState> topMaterial(SurfaceRules.RuleSource var0, CarvingContext var1, Function<BlockPos, Holder<Biome>> var2, ChunkAccess var3, NoiseChunk var4, BlockPos var5, boolean var6) {
        SurfaceRules.Context var7 = new SurfaceRules.Context(this, var1.randomState(), var3, var4, var2, (Registry<Biome>)var1.registryAccess().lookupOrThrow(Registries.BIOME), var1);
        SurfaceRules.SurfaceRule var8 = (SurfaceRules.SurfaceRule)var0.apply(var7);
        int var9 = var5.getX();
        int var10 = var5.getY();
        int var11 = var5.getZ();
        var7.updateXZ(var9, var11);
        var7.updateY(1, 1, var6 ? var10 + 1 : Integer.MIN_VALUE, var9, var10, var11);
        BlockState var12 = var8.tryApply(var9, var10, var11);
        return Optional.ofNullable(var12);
    }

    private void erodedBadlandsExtension(BlockColumn var0, int var1, int var2, int var3, LevelHeightAccessor var4) {
        BlockState var19;
        int var18;
        double var5 = 0.2;
        double var7 = Math.min(Math.abs(this.badlandsSurfaceNoise.getValue(var1, 0.0, var2) * 8.25), this.badlandsPillarNoise.getValue((double)var1 * 0.2, 0.0, (double)var2 * 0.2) * 15.0);
        if (var7 <= 0.0) {
            return;
        }
        double var9 = 0.75;
        double var11 = 1.5;
        double var13 = Math.abs(this.badlandsPillarRoofNoise.getValue((double)var1 * 0.75, 0.0, (double)var2 * 0.75) * 1.5);
        double var15 = 64.0 + Math.min(var7 * var7 * 2.5, Math.ceil(var13 * 50.0) + 24.0);
        int var17 = Mth.floor(var15);
        if (var3 > var17) {
            return;
        }
        for (var18 = var17; var18 >= var4.getMinY() && !(var19 = var0.getBlock(var18)).is(this.defaultBlock.getBlock()); --var18) {
            if (!var19.is(Blocks.WATER)) continue;
            return;
        }
        for (var18 = var17; var18 >= var4.getMinY() && var0.getBlock(var18).isAir(); --var18) {
            var0.setBlock(var18, this.defaultBlock);
        }
    }

    private void frozenOceanExtension(int var0, Biome var1, BlockColumn var2, BlockPos.MutableBlockPos var3, int var4, int var5, int var6) {
        double var11;
        double var7 = 1.28;
        double var9 = Math.min(Math.abs(this.icebergSurfaceNoise.getValue(var4, 0.0, var5) * 8.25), this.icebergPillarNoise.getValue((double)var4 * 1.28, 0.0, (double)var5 * 1.28) * 15.0);
        if (var9 <= 1.8) {
            return;
        }
        double var13 = 1.17;
        double var15 = 1.5;
        double var17 = Math.abs(this.icebergPillarRoofNoise.getValue((double)var4 * 1.17, 0.0, (double)var5 * 1.17) * 1.5);
        double var19 = Math.min(var9 * var9 * 1.2, Math.ceil(var17 * 40.0) + 14.0);
        if (var1.shouldMeltFrozenOceanIcebergSlightly(var3.set(var4, this.seaLevel, var5), this.seaLevel)) {
            var19 -= 2.0;
        }
        if (var19 > 2.0) {
            var11 = (double)this.seaLevel - var19 - 7.0;
            var19 += (double)this.seaLevel;
        } else {
            var19 = 0.0;
            var11 = 0.0;
        }
        double var21 = var19;
        RandomSource var23 = this.noiseRandom.at(var4, 0, var5);
        int var24 = 2 + var23.nextInt(4);
        int var25 = this.seaLevel + 18 + var23.nextInt(10);
        int var26 = 0;
        for (int var27 = Math.max(var6, (int)var21 + 1); var27 >= var0; --var27) {
            if (!(var2.getBlock(var27).isAir() && var27 < (int)var21 && var23.nextDouble() > 0.01) && (!var2.getBlock(var27).is(Blocks.WATER) || var27 <= (int)var11 || var27 >= this.seaLevel || var11 == 0.0 || !(var23.nextDouble() > 0.15))) continue;
            if (var26 <= var24 && var27 > var25) {
                var2.setBlock(var27, SNOW_BLOCK);
                ++var26;
                continue;
            }
            var2.setBlock(var27, PACKED_ICE);
        }
    }

    private static BlockState[] generateBands(RandomSource var0) {
        int var2;
        Object[] var1 = new BlockState[192];
        Arrays.fill(var1, TERRACOTTA);
        for (var2 = 0; var2 < var1.length; ++var2) {
            if ((var2 += var0.nextInt(5) + 1) >= var1.length) continue;
            var1[var2] = ORANGE_TERRACOTTA;
        }
        SurfaceSystem.makeBands(var0, (BlockState[])var1, 1, YELLOW_TERRACOTTA);
        SurfaceSystem.makeBands(var0, (BlockState[])var1, 2, BROWN_TERRACOTTA);
        SurfaceSystem.makeBands(var0, (BlockState[])var1, 1, RED_TERRACOTTA);
        var2 = var0.nextIntBetweenInclusive(9, 15);
        int var3 = 0;
        for (int var4 = 0; var3 < var2 && var4 < var1.length; ++var3, var4 += var0.nextInt(16) + 4) {
            var1[var4] = WHITE_TERRACOTTA;
            if (var4 - 1 > 0 && var0.nextBoolean()) {
                var1[var4 - 1] = LIGHT_GRAY_TERRACOTTA;
            }
            if (var4 + 1 >= var1.length || !var0.nextBoolean()) continue;
            var1[var4 + 1] = LIGHT_GRAY_TERRACOTTA;
        }
        return var1;
    }

    private static void makeBands(RandomSource var0, BlockState[] var1, int var2, BlockState var3) {
        int var4 = var0.nextIntBetweenInclusive(6, 15);
        for (int var5 = 0; var5 < var4; ++var5) {
            int var6 = var2 + var0.nextInt(3);
            int var7 = var0.nextInt(var1.length);
            for (int var8 = 0; var7 + var8 < var1.length && var8 < var6; ++var8) {
                var1[var7 + var8] = var3;
            }
        }
    }

    protected BlockState getBand(int var0, int var1, int var2) {
        int var3 = (int)Math.round(this.clayBandsOffsetNoise.getValue(var0, 0.0, var2) * 4.0);
        return this.clayBands[(var1 + var3 + this.clayBands.length) % this.clayBands.length];
    }
}

