/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveWorldCarver;
import net.minecraft.world.level.material.Fluids;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class NetherWorldCarver
extends CaveWorldCarver {
    public NetherWorldCarver(Codec<CaveCarverConfiguration> var0) {
        super(var0);
        this.liquids = ImmutableSet.of((Object)Fluids.LAVA, (Object)Fluids.WATER);
    }

    @Override
    protected int getCaveBound() {
        return 10;
    }

    @Override
    protected float getThickness(RandomSource var0) {
        return (var0.nextFloat() * 2.0f + var0.nextFloat()) * 2.0f;
    }

    @Override
    protected double getYScale() {
        return 5.0;
    }

    @Override
    protected boolean carveBlock(CarvingContext var0, CaveCarverConfiguration var1, ChunkAccess var2, Function<BlockPos, Holder<Biome>> var3, CarvingMask var4, BlockPos.MutableBlockPos var5, BlockPos.MutableBlockPos var6, Aquifer var7, MutableBoolean var8) {
        if (this.canReplaceBlock(var1, var2.getBlockState(var5))) {
            BlockState var9 = var5.getY() <= var0.getMinGenY() + 31 ? LAVA.createLegacyBlock() : CAVE_AIR;
            var2.setBlockState(var5, var9);
            return true;
        }
        return false;
    }
}

