/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import org.jspecify.annotations.Nullable;

public class BasaltColumnsFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.LAVA, (Object)Blocks.BEDROCK, (Object)Blocks.MAGMA_BLOCK, (Object)Blocks.SOUL_SAND, (Object)Blocks.NETHER_BRICKS, (Object)Blocks.NETHER_BRICK_FENCE, (Object)Blocks.NETHER_BRICK_STAIRS, (Object)Blocks.NETHER_WART, (Object)Blocks.CHEST, (Object)Blocks.SPAWNER);
    private static final int CLUSTERED_REACH = 5;
    private static final int CLUSTERED_SIZE = 50;
    private static final int UNCLUSTERED_REACH = 8;
    private static final int UNCLUSTERED_SIZE = 15;

    public BasaltColumnsFeature(Codec<ColumnFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<ColumnFeatureConfiguration> var0) {
        int var1 = var0.chunkGenerator().getSeaLevel();
        BlockPos var2 = var0.origin();
        WorldGenLevel var3 = var0.level();
        RandomSource var4 = var0.random();
        ColumnFeatureConfiguration var5 = var0.config();
        if (!BasaltColumnsFeature.canPlaceAt(var3, var1, var2.mutable())) {
            return false;
        }
        int var6 = var5.height().sample(var4);
        boolean var7 = var4.nextFloat() < 0.9f;
        int var8 = Math.min(var6, var7 ? 5 : 8);
        int var9 = var7 ? 50 : 15;
        boolean var10 = false;
        for (BlockPos var12 : BlockPos.randomBetweenClosed(var4, var9, var2.getX() - var8, var2.getY(), var2.getZ() - var8, var2.getX() + var8, var2.getY(), var2.getZ() + var8)) {
            int var13 = var6 - var12.distManhattan(var2);
            if (var13 < 0) continue;
            var10 |= this.placeColumn(var3, var1, var12, var13, var5.reach().sample(var4));
        }
        return var10;
    }

    private boolean placeColumn(LevelAccessor var0, int var1, BlockPos var2, int var3, int var4) {
        boolean var5 = false;
        block0: for (BlockPos var7 : BlockPos.betweenClosed(var2.getX() - var4, var2.getY(), var2.getZ() - var4, var2.getX() + var4, var2.getY(), var2.getZ() + var4)) {
            BlockPos var9;
            int var8 = var7.distManhattan(var2);
            BlockPos blockPos = var9 = BasaltColumnsFeature.isAirOrLavaOcean(var0, var1, var7) ? BasaltColumnsFeature.findSurface(var0, var1, var7.mutable(), var8) : BasaltColumnsFeature.findAir(var0, var7.mutable(), var8);
            if (var9 == null) continue;
            BlockPos.MutableBlockPos var11 = var9.mutable();
            for (int var10 = var3 - var8 / 2; var10 >= 0; --var10) {
                if (BasaltColumnsFeature.isAirOrLavaOcean(var0, var1, var11)) {
                    this.setBlock(var0, var11, Blocks.BASALT.defaultBlockState());
                    var11.move(Direction.UP);
                    var5 = true;
                    continue;
                }
                if (!var0.getBlockState(var11).is(Blocks.BASALT)) continue block0;
                var11.move(Direction.UP);
            }
        }
        return var5;
    }

    private static @Nullable BlockPos findSurface(LevelAccessor var0, int var1, BlockPos.MutableBlockPos var2, int var3) {
        while (var2.getY() > var0.getMinY() + 1 && var3 > 0) {
            --var3;
            if (BasaltColumnsFeature.canPlaceAt(var0, var1, var2)) {
                return var2;
            }
            var2.move(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor var0, int var1, BlockPos.MutableBlockPos var2) {
        if (BasaltColumnsFeature.isAirOrLavaOcean(var0, var1, var2)) {
            BlockState var3 = var0.getBlockState(var2.move(Direction.DOWN));
            var2.move(Direction.UP);
            return !var3.isAir() && !CANNOT_PLACE_ON.contains((Object)var3.getBlock());
        }
        return false;
    }

    private static @Nullable BlockPos findAir(LevelAccessor var0, BlockPos.MutableBlockPos var1, int var2) {
        while (var1.getY() <= var0.getMaxY() && var2 > 0) {
            --var2;
            BlockState var3 = var0.getBlockState(var1);
            if (CANNOT_PLACE_ON.contains((Object)var3.getBlock())) {
                return null;
            }
            if (var3.isAir()) {
                return var1;
            }
            var1.move(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor var0, int var1, BlockPos var2) {
        BlockState var3 = var0.getBlockState(var2);
        return var3.isAir() || var3.is(Blocks.LAVA) && var2.getY() <= var1;
    }
}

