/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class BonusChestFeature
extends Feature<NoneFeatureConfiguration> {
    public BonusChestFeature(Codec<NoneFeatureConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> var0) {
        RandomSource var1 = var0.random();
        WorldGenLevel var2 = var0.level();
        ChunkPos var3 = new ChunkPos(var0.origin());
        IntArrayList var4 = Util.toShuffledList(IntStream.rangeClosed(var3.getMinBlockX(), var3.getMaxBlockX()), var1);
        IntArrayList var5 = Util.toShuffledList(IntStream.rangeClosed(var3.getMinBlockZ(), var3.getMaxBlockZ()), var1);
        BlockPos.MutableBlockPos var6 = new BlockPos.MutableBlockPos();
        for (Integer var8 : var4) {
            for (Integer var10 : var5) {
                var6.set(var8, 0, var10);
                BlockPos var11 = var2.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, var6);
                if (!var2.isEmptyBlock(var11) && !var2.getBlockState(var11).getCollisionShape(var2, var11).isEmpty()) continue;
                var2.setBlock(var11, Blocks.CHEST.defaultBlockState(), 2);
                RandomizableContainer.setBlockEntityLootTable(var2, var1, var11, BuiltInLootTables.SPAWN_BONUS_CHEST);
                BlockState var12 = Blocks.TORCH.defaultBlockState();
                for (Direction var14 : Direction.Plane.HORIZONTAL) {
                    BlockPos var15 = var11.relative(var14);
                    if (!var12.canSurvive(var2, var15)) continue;
                    var2.setBlock(var15, var12, 2);
                }
                return true;
            }
        }
        return false;
    }
}

