/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;

public class IcebergFeature
extends Feature<BlockStateConfiguration> {
    public IcebergFeature(Codec<BlockStateConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<BlockStateConfiguration> var0) {
        int var19;
        int var18;
        int var17;
        int var16;
        int var12;
        BlockPos var1 = var0.origin();
        WorldGenLevel var2 = var0.level();
        var1 = new BlockPos(var1.getX(), var0.chunkGenerator().getSeaLevel(), var1.getZ());
        RandomSource var3 = var0.random();
        boolean var4 = var3.nextDouble() > 0.7;
        BlockState var5 = var0.config().state;
        double var6 = var3.nextDouble() * 2.0 * Math.PI;
        int var8 = 11 - var3.nextInt(5);
        int var9 = 3 + var3.nextInt(3);
        boolean var10 = var3.nextDouble() > 0.7;
        int var11 = 11;
        int n = var12 = var10 ? var3.nextInt(6) + 6 : var3.nextInt(15) + 3;
        if (!var10 && var3.nextDouble() > 0.9) {
            var12 += var3.nextInt(19) + 7;
        }
        int var13 = Math.min(var12 + var3.nextInt(11), 18);
        int var14 = Math.min(var12 + var3.nextInt(7) - var3.nextInt(5), 11);
        int var15 = var10 ? var8 : 11;
        for (var16 = -var15; var16 < var15; ++var16) {
            for (var17 = -var15; var17 < var15; ++var17) {
                for (var18 = 0; var18 < var12; ++var18) {
                    int n2 = var19 = var10 ? this.heightDependentRadiusEllipse(var18, var12, var14) : this.heightDependentRadiusRound(var3, var18, var12, var14);
                    if (!var10 && var16 >= var19) continue;
                    this.generateIcebergBlock(var2, var3, var1, var12, var16, var18, var17, var19, var15, var10, var9, var6, var4, var5);
                }
            }
        }
        this.smooth(var2, var1, var14, var12, var10, var8);
        for (var16 = -var15; var16 < var15; ++var16) {
            for (var17 = -var15; var17 < var15; ++var17) {
                for (var18 = -1; var18 > -var13; --var18) {
                    var19 = var10 ? Mth.ceil((float)var15 * (1.0f - (float)Math.pow(var18, 2.0) / ((float)var13 * 8.0f))) : var15;
                    int var20 = this.heightDependentRadiusSteep(var3, -var18, var13, var14);
                    if (var16 >= var20) continue;
                    this.generateIcebergBlock(var2, var3, var1, var13, var16, var18, var17, var20, var19, var10, var9, var6, var4, var5);
                }
            }
        }
        int n3 = var10 ? (var3.nextDouble() > 0.1 ? 1 : 0) : (var16 = var3.nextDouble() > 0.7 ? 1 : 0);
        if (var16 != 0) {
            this.generateCutOut(var3, var2, var14, var12, var1, var10, var8, var6, var9);
        }
        return true;
    }

    private void generateCutOut(RandomSource var0, LevelAccessor var1, int var2, int var3, BlockPos var4, boolean var5, int var6, double var7, int var9) {
        int var18;
        int var17;
        int var10 = var0.nextBoolean() ? -1 : 1;
        int var11 = var0.nextBoolean() ? -1 : 1;
        int var12 = var0.nextInt(Math.max(var2 / 2 - 2, 1));
        if (var0.nextBoolean()) {
            var12 = var2 / 2 + 1 - var0.nextInt(Math.max(var2 - var2 / 2 - 1, 1));
        }
        int var13 = var0.nextInt(Math.max(var2 / 2 - 2, 1));
        if (var0.nextBoolean()) {
            var13 = var2 / 2 + 1 - var0.nextInt(Math.max(var2 - var2 / 2 - 1, 1));
        }
        if (var5) {
            var12 = var13 = var0.nextInt(Math.max(var6 - 5, 1));
        }
        BlockPos var14 = new BlockPos(var10 * var12, 0, var11 * var13);
        double var15 = var5 ? var7 + 1.5707963267948966 : var0.nextDouble() * 2.0 * Math.PI;
        for (var17 = 0; var17 < var3 - 3; ++var17) {
            var18 = this.heightDependentRadiusRound(var0, var17, var3, var2);
            this.carve(var18, var17, var4, var1, false, var15, var14, var6, var9);
        }
        for (var17 = -1; var17 > -var3 + var0.nextInt(5); --var17) {
            var18 = this.heightDependentRadiusSteep(var0, -var17, var3, var2);
            this.carve(var18, var17, var4, var1, true, var15, var14, var6, var9);
        }
    }

    private void carve(int var0, int var1, BlockPos var2, LevelAccessor var3, boolean var4, double var5, BlockPos var7, int var8, int var9) {
        int var10 = var0 + 1 + var8 / 3;
        int var11 = Math.min(var0 - 3, 3) + var9 / 2 - 1;
        for (int var12 = -var10; var12 < var10; ++var12) {
            for (int var13 = -var10; var13 < var10; ++var13) {
                BlockPos var16;
                BlockState var17;
                double var14 = this.signedDistanceEllipse(var12, var13, var7, var10, var11, var5);
                if (!(var14 < 0.0) || !IcebergFeature.isIcebergState(var17 = var3.getBlockState(var16 = var2.offset(var12, var1, var13))) && !var17.is(Blocks.SNOW_BLOCK)) continue;
                if (var4) {
                    this.setBlock(var3, var16, Blocks.WATER.defaultBlockState());
                    continue;
                }
                this.setBlock(var3, var16, Blocks.AIR.defaultBlockState());
                this.removeFloatingSnowLayer(var3, var16);
            }
        }
    }

    private void removeFloatingSnowLayer(LevelAccessor var0, BlockPos var1) {
        if (var0.getBlockState(var1.above()).is(Blocks.SNOW)) {
            this.setBlock(var0, var1.above(), Blocks.AIR.defaultBlockState());
        }
    }

    private void generateIcebergBlock(LevelAccessor var0, RandomSource var1, BlockPos var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, int var10, double var11, boolean var13, BlockState var14) {
        double var15;
        double d = var15 = var9 ? this.signedDistanceEllipse(var4, var6, BlockPos.ZERO, var8, this.getEllipseC(var5, var3, var10), var11) : this.signedDistanceCircle(var4, var6, BlockPos.ZERO, var7, var1);
        if (var15 < 0.0) {
            double var18;
            BlockPos var17 = var2.offset(var4, var5, var6);
            double d2 = var18 = var9 ? -0.5 : (double)(-6 - var1.nextInt(3));
            if (var15 > var18 && var1.nextDouble() > 0.9) {
                return;
            }
            this.setIcebergBlock(var17, var0, var1, var3 - var5, var3, var9, var13, var14);
        }
    }

    private void setIcebergBlock(BlockPos var0, LevelAccessor var1, RandomSource var2, int var3, int var4, boolean var5, boolean var6, BlockState var7) {
        BlockState var8 = var1.getBlockState(var0);
        if (var8.isAir() || var8.is(Blocks.SNOW_BLOCK) || var8.is(Blocks.ICE) || var8.is(Blocks.WATER)) {
            int var10;
            boolean var9 = !var5 || var2.nextDouble() > 0.05;
            int n = var10 = var5 ? 3 : 2;
            if (var6 && !var8.is(Blocks.WATER) && (double)var3 <= (double)var2.nextInt(Math.max(1, var4 / var10)) + (double)var4 * 0.6 && var9) {
                this.setBlock(var1, var0, Blocks.SNOW_BLOCK.defaultBlockState());
            } else {
                this.setBlock(var1, var0, var7);
            }
        }
    }

    private int getEllipseC(int var0, int var1, int var2) {
        int var3 = var2;
        if (var0 > 0 && var1 - var0 <= 3) {
            var3 -= 4 - (var1 - var0);
        }
        return var3;
    }

    private double signedDistanceCircle(int var0, int var1, BlockPos var2, int var3, RandomSource var4) {
        float var5 = 10.0f * Mth.clamp(var4.nextFloat(), 0.2f, 0.8f) / (float)var3;
        return (double)var5 + Math.pow(var0 - var2.getX(), 2.0) + Math.pow(var1 - var2.getZ(), 2.0) - Math.pow(var3, 2.0);
    }

    private double signedDistanceEllipse(int var0, int var1, BlockPos var2, int var3, int var4, double var5) {
        return Math.pow(((double)(var0 - var2.getX()) * Math.cos(var5) - (double)(var1 - var2.getZ()) * Math.sin(var5)) / (double)var3, 2.0) + Math.pow(((double)(var0 - var2.getX()) * Math.sin(var5) + (double)(var1 - var2.getZ()) * Math.cos(var5)) / (double)var4, 2.0) - 1.0;
    }

    private int heightDependentRadiusRound(RandomSource var0, int var1, int var2, int var3) {
        float var4 = 3.5f - var0.nextFloat();
        float var5 = (1.0f - (float)Math.pow(var1, 2.0) / ((float)var2 * var4)) * (float)var3;
        if (var2 > 15 + var0.nextInt(5)) {
            int var6 = var1 < 3 + var0.nextInt(6) ? var1 / 2 : var1;
            var5 = (1.0f - (float)var6 / ((float)var2 * var4 * 0.4f)) * (float)var3;
        }
        return Mth.ceil(var5 / 2.0f);
    }

    private int heightDependentRadiusEllipse(int var0, int var1, int var2) {
        float var3 = 1.0f;
        float var4 = (1.0f - (float)Math.pow(var0, 2.0) / ((float)var1 * 1.0f)) * (float)var2;
        return Mth.ceil(var4 / 2.0f);
    }

    private int heightDependentRadiusSteep(RandomSource var0, int var1, int var2, int var3) {
        float var4 = 1.0f + var0.nextFloat() / 2.0f;
        float var5 = (1.0f - (float)var1 / ((float)var2 * var4)) * (float)var3;
        return Mth.ceil(var5 / 2.0f);
    }

    private static boolean isIcebergState(BlockState var0) {
        return var0.is(Blocks.PACKED_ICE) || var0.is(Blocks.SNOW_BLOCK) || var0.is(Blocks.BLUE_ICE);
    }

    private boolean belowIsAir(BlockGetter var0, BlockPos var1) {
        return var0.getBlockState(var1.below()).isAir();
    }

    private void smooth(LevelAccessor var0, BlockPos var1, int var2, int var3, boolean var4, int var5) {
        int var6 = var4 ? var5 : var2 / 2;
        for (int var7 = -var6; var7 <= var6; ++var7) {
            for (int var8 = -var6; var8 <= var6; ++var8) {
                for (int var9 = 0; var9 <= var3; ++var9) {
                    BlockPos var10 = var1.offset(var7, var9, var8);
                    BlockState var11 = var0.getBlockState(var10);
                    if (!IcebergFeature.isIcebergState(var11) && !var11.is(Blocks.SNOW)) continue;
                    if (this.belowIsAir(var0, var10)) {
                        this.setBlock(var0, var10, Blocks.AIR.defaultBlockState());
                        this.setBlock(var0, var10.above(), Blocks.AIR.defaultBlockState());
                        continue;
                    }
                    if (!IcebergFeature.isIcebergState(var11)) continue;
                    BlockState[] var12 = new BlockState[]{var0.getBlockState(var10.west()), var0.getBlockState(var10.east()), var0.getBlockState(var10.north()), var0.getBlockState(var10.south())};
                    int var13 = 0;
                    for (BlockState var17 : var12) {
                        if (IcebergFeature.isIcebergState(var17)) continue;
                        ++var13;
                    }
                    if (var13 < 3) continue;
                    this.setBlock(var0, var10, Blocks.AIR.defaultBlockState());
                }
            }
        }
    }
}

