/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.RootSystemConfiguration;

public class RootSystemFeature
extends Feature<RootSystemConfiguration> {
    public RootSystemFeature(Codec<RootSystemConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<RootSystemConfiguration> var0) {
        BlockPos var2;
        WorldGenLevel var1 = var0.level();
        if (!var1.getBlockState(var2 = var0.origin()).isAir()) {
            return false;
        }
        RandomSource var3 = var0.random();
        BlockPos var4 = var0.origin();
        RootSystemConfiguration var5 = var0.config();
        BlockPos.MutableBlockPos var6 = var4.mutable();
        if (RootSystemFeature.placeDirtAndTree(var1, var0.chunkGenerator(), var5, var3, var6, var4)) {
            RootSystemFeature.placeRoots(var1, var5, var3, var4, var6);
        }
        return true;
    }

    private static boolean spaceForTree(WorldGenLevel var0, RootSystemConfiguration var1, BlockPos var2) {
        BlockPos.MutableBlockPos var3 = var2.mutable();
        for (int var4 = 1; var4 <= var1.requiredVerticalSpaceForTree; ++var4) {
            var3.move(Direction.UP);
            BlockState var5 = var0.getBlockState(var3);
            if (RootSystemFeature.isAllowedTreeSpace(var5, var4, var1.allowedVerticalWaterForTree)) continue;
            return false;
        }
        return true;
    }

    private static boolean isAllowedTreeSpace(BlockState var0, int var1, int var2) {
        if (var0.isAir()) {
            return true;
        }
        int var3 = var1 + 1;
        return var3 <= var2 && var0.getFluidState().is(FluidTags.WATER);
    }

    private static boolean placeDirtAndTree(WorldGenLevel var0, ChunkGenerator var1, RootSystemConfiguration var2, RandomSource var3, BlockPos.MutableBlockPos var4, BlockPos var5) {
        for (int var6 = 0; var6 < var2.rootColumnMaxHeight; ++var6) {
            var4.move(Direction.UP);
            if (!var2.allowedTreePosition.test(var0, var4) || !RootSystemFeature.spaceForTree(var0, var2, var4)) continue;
            Vec3i var7 = var4.below();
            if (var0.getFluidState((BlockPos)var7).is(FluidTags.LAVA) || !var0.getBlockState((BlockPos)var7).isSolid()) {
                return false;
            }
            if (!var2.treeFeature.value().place(var0, var1, var3, var4)) continue;
            RootSystemFeature.placeDirt(var5, var5.getY() + var6, var0, var2, var3);
            return true;
        }
        return false;
    }

    private static void placeDirt(BlockPos var0, int var1, WorldGenLevel var2, RootSystemConfiguration var3, RandomSource var4) {
        int var5 = var0.getX();
        int var6 = var0.getZ();
        BlockPos.MutableBlockPos var7 = var0.mutable();
        for (int var8 = var0.getY(); var8 < var1; ++var8) {
            RootSystemFeature.placeRootedDirt(var2, var3, var4, var5, var6, var7.set(var5, var8, var6));
        }
    }

    private static void placeRootedDirt(WorldGenLevel var0, RootSystemConfiguration var12, RandomSource var2, int var3, int var4, BlockPos.MutableBlockPos var5) {
        int var6 = var12.rootRadius;
        Predicate<BlockState> var7 = var1 -> var1.is(var0.rootReplaceable);
        for (int var8 = 0; var8 < var12.rootPlacementAttempts; ++var8) {
            var5.setWithOffset(var5, var2.nextInt(var6) - var2.nextInt(var6), 0, var2.nextInt(var6) - var2.nextInt(var6));
            if (var7.test(var0.getBlockState(var5))) {
                var0.setBlock(var5, var12.rootStateProvider.getState(var2, var5), 2);
            }
            var5.setX(var3);
            var5.setZ(var4);
        }
    }

    private static void placeRoots(WorldGenLevel var0, RootSystemConfiguration var1, RandomSource var2, BlockPos var3, BlockPos.MutableBlockPos var4) {
        int var5 = var1.hangingRootRadius;
        int var6 = var1.hangingRootsVerticalSpan;
        for (int var7 = 0; var7 < var1.hangingRootPlacementAttempts; ++var7) {
            BlockState var8;
            var4.setWithOffset(var3, var2.nextInt(var5) - var2.nextInt(var5), var2.nextInt(var6) - var2.nextInt(var6), var2.nextInt(var5) - var2.nextInt(var5));
            if (!var0.isEmptyBlock(var4) || !(var8 = var1.hangingRootStateProvider.getState(var2, var4)).canSurvive(var0, var4) || !var0.getBlockState((BlockPos)var4.above()).isFaceSturdy(var0, var4, Direction.DOWN)) continue;
            var0.setBlock(var4, var8, 2);
        }
    }
}

