/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class TreeFeature
extends Feature<TreeConfiguration> {
    @Block.UpdateFlags
    private static final int BLOCK_UPDATE_FLAGS = 19;

    public TreeFeature(Codec<TreeConfiguration> var0) {
        super(var0);
    }

    public static boolean isVine(LevelSimulatedReader var02, BlockPos var1) {
        return var02.isStateAtPosition(var1, var0 -> var0.is(Blocks.VINE));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader var02, BlockPos var1) {
        return var02.isStateAtPosition(var1, var0 -> var0.isAir() || var0.is(BlockTags.LEAVES));
    }

    private static void setBlockKnownShape(LevelWriter var0, BlockPos var1, BlockState var2) {
        var0.setBlock(var1, var2, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader var02, BlockPos var1) {
        return var02.isStateAtPosition(var1, var0 -> var0.isAir() || var0.is(BlockTags.REPLACEABLE_BY_TREES));
    }

    private boolean doPlace(WorldGenLevel var0, RandomSource var1, BlockPos var22, BiConsumer<BlockPos, BlockState> var3, BiConsumer<BlockPos, BlockState> var4, FoliagePlacer.FoliageSetter var5, TreeConfiguration var6) {
        int var72 = var6.trunkPlacer.getTreeHeight(var1);
        int var8 = var6.foliagePlacer.foliageHeight(var1, var72, var6);
        int var9 = var72 - var8;
        int var10 = var6.foliagePlacer.foliageRadius(var1, var9);
        BlockPos var11 = var6.rootPlacer.map(var2 -> var2.getTrunkOrigin(var22, var1)).orElse(var22);
        int var12 = Math.min(var22.getY(), var11.getY());
        int var13 = Math.max(var22.getY(), var11.getY()) + var72 + 1;
        if (var12 < var0.getMinY() + 1 || var13 > var0.getMaxY() + 1) {
            return false;
        }
        OptionalInt var14 = var6.minimumSize.minClippedHeight();
        int var15 = this.getMaxFreeTreeHeight(var0, var72, var11, var6);
        if (var15 < var72 && (var14.isEmpty() || var15 < var14.getAsInt())) {
            return false;
        }
        if (var6.rootPlacer.isPresent() && !var6.rootPlacer.get().placeRoots(var0, var3, var1, var22, var11, var6)) {
            return false;
        }
        List<FoliagePlacer.FoliageAttachment> var16 = var6.trunkPlacer.placeTrunk(var0, var4, var1, var15, var11, var6);
        var16.forEach(var7 -> var0.foliagePlacer.createFoliage(var0, var5, var1, var6, var15, (FoliagePlacer.FoliageAttachment)var7, var8, var10));
        return true;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader var0, int var1, BlockPos var2, TreeConfiguration var3) {
        BlockPos.MutableBlockPos var4 = new BlockPos.MutableBlockPos();
        for (int var5 = 0; var5 <= var1 + 1; ++var5) {
            int var6 = var3.minimumSize.getSizeAtHeight(var1, var5);
            for (int var7 = -var6; var7 <= var6; ++var7) {
                for (int var8 = -var6; var8 <= var6; ++var8) {
                    var4.setWithOffset(var2, var7, var5, var8);
                    if (var3.trunkPlacer.isFree(var0, var4) && (var3.ignoreVines || !TreeFeature.isVine(var0, var4))) continue;
                    return var5 - 2;
                }
            }
        }
        return var1;
    }

    @Override
    protected void setBlock(LevelWriter var0, BlockPos var1, BlockState var2) {
        TreeFeature.setBlockKnownShape(var0, var1, var2);
    }

    @Override
    public final boolean place(FeaturePlaceContext<TreeConfiguration> var0) {
        final WorldGenLevel var12 = var0.level();
        RandomSource var22 = var0.random();
        BlockPos var32 = var0.origin();
        TreeConfiguration var42 = var0.config();
        HashSet var5 = Sets.newHashSet();
        HashSet var6 = Sets.newHashSet();
        final HashSet var7 = Sets.newHashSet();
        HashSet var8 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> var9 = (var2, var3) -> {
            var5.add(var2.immutable());
            var12.setBlock((BlockPos)var2, (BlockState)var3, 19);
        };
        BiConsumer<BlockPos, BlockState> var10 = (var2, var3) -> {
            var6.add(var2.immutable());
            var12.setBlock((BlockPos)var2, (BlockState)var3, 19);
        };
        FoliagePlacer.FoliageSetter var11 = new FoliagePlacer.FoliageSetter(this){

            @Override
            public void set(BlockPos var0, BlockState var1) {
                var7.add(var0.immutable());
                var12.setBlock(var0, var1, 19);
            }

            @Override
            public boolean isSet(BlockPos var0) {
                return var7.contains(var0);
            }
        };
        BiConsumer<BlockPos, BlockState> var122 = (var2, var3) -> {
            var8.add(var2.immutable());
            var12.setBlock((BlockPos)var2, (BlockState)var3, 19);
        };
        boolean var13 = this.doPlace(var12, var22, var32, var9, var10, var11, var42);
        if (!var13 || var6.isEmpty() && var7.isEmpty()) {
            return false;
        }
        if (!var42.decorators.isEmpty()) {
            TreeDecorator.Context var14 = new TreeDecorator.Context(var12, var122, var22, var6, var7, var5);
            var42.decorators.forEach(var1 -> var1.place(var14));
        }
        return BoundingBox.encapsulatingPositions(Iterables.concat((Iterable)var5, (Iterable)var6, (Iterable)var7, (Iterable)var8)).map(var4 -> {
            DiscreteVoxelShape var5 = TreeFeature.updateLeaves(var12, var4, var6, var8, var5);
            StructureTemplate.updateShapeAtEdge(var12, 3, var5, var4.minX(), var4.minY(), var4.minZ());
            return true;
        }).orElse(false);
    }

    /*
     * Unable to fully structure code
     */
    private static DiscreteVoxelShape updateLeaves(LevelAccessor var0, BoundingBox var1, Set<BlockPos> var2, Set<BlockPos> var3, Set<BlockPos> var4) {
        var5 = new BitSetDiscreteVoxelShape(var1.getXSpan(), var1.getYSpan(), var1.getZSpan());
        var6 = 7;
        var7 = Lists.newArrayList();
        for (var8 = 0; var8 < 7; ++var8) {
            var7.add(Sets.newHashSet());
        }
        for (BlockPos var9 : Lists.newArrayList((Iterable)Sets.union(var3, var4))) {
            if (!var1.isInside(var9)) continue;
            var5.fill(var9.getX() - var1.minX(), var9.getY() - var1.minY(), var9.getZ() - var1.minZ());
        }
        var8 = new BlockPos.MutableBlockPos();
        var9 = 0;
        ((Set)var7.get(0)).addAll(var2);
        block2: while (true) {
            if (var9 < 7 && ((Set)var7.get(var9)).isEmpty()) {
                ++var9;
                continue;
            }
            if (var9 >= 7) break;
            var10 = ((Set)var7.get(var9)).iterator();
            var11 = (BlockPos)var10.next();
            var10.remove();
            if (!var1.isInside(var11)) continue;
            if (var9 != 0) {
                var12 = var0.getBlockState(var11);
                TreeFeature.setBlockKnownShape(var0, var11, (BlockState)var12.setValue(BlockStateProperties.DISTANCE, var9));
            }
            var5.fill(var11.getX() - var1.minX(), var11.getY() - var1.minY(), var11.getZ() - var1.minZ());
            var12_14 = Direction.values();
            var13_15 = var12_14.length;
            var14_16 = 0;
            while (true) {
                if (var14_16 < var13_15) ** break;
                continue block2;
                var15 = var12_14[var14_16];
                var8.setWithOffset((Vec3i)var11, var15);
                if (var1.isInside(var8) && !var5.isFull(var16 = var8.getX() - var1.minX(), var17 = var8.getY() - var1.minY(), var18 = var8.getZ() - var1.minZ()) && !(var20 = LeavesBlock.getOptionalDistanceAt(var19 = var0.getBlockState(var8))).isEmpty() && (var21 = Math.min(var20.getAsInt(), var9 + 1)) < 7) {
                    ((Set)var7.get(var21)).add(var8.immutable());
                    var9 = Math.min(var9, var21);
                }
                ++var14_16;
            }
            break;
        }
        return var5;
    }

    public static List<BlockPos> getLowestTrunkOrRootOfTree(TreeDecorator.Context var0) {
        ArrayList var1 = Lists.newArrayList();
        ObjectArrayList<BlockPos> var2 = var0.roots();
        ObjectArrayList<BlockPos> var3 = var0.logs();
        if (var2.isEmpty()) {
            var1.addAll(var3);
        } else if (!var3.isEmpty() && ((BlockPos)var2.get(0)).getY() == ((BlockPos)var3.get(0)).getY()) {
            var1.addAll(var3);
            var1.addAll(var2);
        } else {
            var1.addAll(var2);
        }
        return var1;
    }
}

