/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.UnderwaterMagmaConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class UnderwaterMagmaFeature
extends Feature<UnderwaterMagmaConfiguration> {
    public UnderwaterMagmaFeature(Codec<UnderwaterMagmaConfiguration> var0) {
        super(var0);
    }

    @Override
    public boolean place(FeaturePlaceContext<UnderwaterMagmaConfiguration> var0) {
        Vec3i var7;
        WorldGenLevel var12 = var0.level();
        BlockPos var22 = var0.origin();
        UnderwaterMagmaConfiguration var3 = var0.config();
        RandomSource var4 = var0.random();
        OptionalInt var5 = UnderwaterMagmaFeature.getFloorY(var12, var22, var3);
        if (var5.isEmpty()) {
            return false;
        }
        BlockPos var6 = var22.atY(var5.getAsInt());
        BoundingBox var8 = BoundingBox.fromCorners(var6.subtract(var7 = new Vec3i(var3.placementRadiusAroundFloor, var3.placementRadiusAroundFloor, var3.placementRadiusAroundFloor)), var6.offset(var7));
        return BlockPos.betweenClosedStream(var8).filter(var2 -> var4.nextFloat() < var1.placementProbabilityPerValidPosition).filter(var1 -> this.isValidPlacement(var12, (BlockPos)var1)).mapToInt(var1 -> {
            var12.setBlock((BlockPos)var1, Blocks.MAGMA_BLOCK.defaultBlockState(), 2);
            return 1;
        }).sum() > 0;
    }

    private static OptionalInt getFloorY(WorldGenLevel var02, BlockPos var1, UnderwaterMagmaConfiguration var2) {
        Predicate<BlockState> var3 = var0 -> var0.is(Blocks.WATER);
        Predicate<BlockState> var4 = var0 -> !var0.is(Blocks.WATER);
        Optional<Column> var5 = Column.scan(var02, var1, var2.floorSearchRange, var3, var4);
        return var5.map(Column::getFloor).orElseGet(OptionalInt::empty);
    }

    private boolean isValidPlacement(WorldGenLevel var0, BlockPos var1) {
        if (UnderwaterMagmaFeature.isWaterOrAir(var0.getBlockState(var1)) || this.isVisibleFromOutside(var0, var1.below(), Direction.UP)) {
            return false;
        }
        for (Direction var3 : Direction.Plane.HORIZONTAL) {
            if (!this.isVisibleFromOutside(var0, var1.relative(var3), var3.getOpposite())) continue;
            return false;
        }
        return true;
    }

    private static boolean isWaterOrAir(BlockState var0) {
        return var0.is(Blocks.WATER) || var0.isAir();
    }

    private boolean isVisibleFromOutside(LevelAccessor var0, BlockPos var1, Direction var2) {
        BlockState var3 = var0.getBlockState(var1);
        VoxelShape var4 = var3.getFaceOcclusionShape(var2);
        return var4 == Shapes.empty() || !Block.isShapeFullBlock(var4);
    }
}

