/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceSpreadeableBlock;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class MultifaceGrowthConfiguration
implements FeatureConfiguration {
    public static final Codec<MultifaceGrowthConfiguration> CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("block").flatXmap(MultifaceGrowthConfiguration::apply, DataResult::success).orElse((Object)((MultifaceSpreadeableBlock)Blocks.GLOW_LICHEN)).forGetter(var0 -> var0.placeBlock), (App)Codec.intRange((int)1, (int)64).fieldOf("search_range").orElse((Object)10).forGetter(var0 -> var0.searchRange), (App)Codec.BOOL.fieldOf("can_place_on_floor").orElse((Object)false).forGetter(var0 -> var0.canPlaceOnFloor), (App)Codec.BOOL.fieldOf("can_place_on_ceiling").orElse((Object)false).forGetter(var0 -> var0.canPlaceOnCeiling), (App)Codec.BOOL.fieldOf("can_place_on_wall").orElse((Object)false).forGetter(var0 -> var0.canPlaceOnWall), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("chance_of_spreading").orElse((Object)Float.valueOf(0.5f)).forGetter(var0 -> Float.valueOf(var0.chanceOfSpreading)), (App)RegistryCodecs.homogeneousList(Registries.BLOCK).fieldOf("can_be_placed_on").forGetter(var0 -> var0.canBePlacedOn)).apply((Applicative)var02, MultifaceGrowthConfiguration::new));
    public final MultifaceSpreadeableBlock placeBlock;
    public final int searchRange;
    public final boolean canPlaceOnFloor;
    public final boolean canPlaceOnCeiling;
    public final boolean canPlaceOnWall;
    public final float chanceOfSpreading;
    public final HolderSet<Block> canBePlacedOn;
    private final ObjectArrayList<Direction> validDirections;

    private static DataResult<MultifaceSpreadeableBlock> apply(Block var0) {
        DataResult dataResult;
        if (var0 instanceof MultifaceSpreadeableBlock) {
            MultifaceSpreadeableBlock var1 = (MultifaceSpreadeableBlock)var0;
            dataResult = DataResult.success((Object)var1);
        } else {
            dataResult = DataResult.error(() -> "Growth block should be a multiface spreadeable block");
        }
        return dataResult;
    }

    public MultifaceGrowthConfiguration(MultifaceSpreadeableBlock var0, int var1, boolean var2, boolean var3, boolean var4, float var5, HolderSet<Block> var6) {
        this.placeBlock = var0;
        this.searchRange = var1;
        this.canPlaceOnFloor = var2;
        this.canPlaceOnCeiling = var3;
        this.canPlaceOnWall = var4;
        this.chanceOfSpreading = var5;
        this.canBePlacedOn = var6;
        this.validDirections = new ObjectArrayList(6);
        if (var3) {
            this.validDirections.add((Object)Direction.UP);
        }
        if (var2) {
            this.validDirections.add((Object)Direction.DOWN);
        }
        if (var4) {
            Direction.Plane.HORIZONTAL.forEach(arg_0 -> this.validDirections.add(arg_0));
        }
    }

    public List<Direction> getShuffledDirectionsExcept(RandomSource var0, Direction var12) {
        return Util.toShuffledList(this.validDirections.stream().filter(var1 -> var1 != var12), var0);
    }

    public List<Direction> getShuffledDirections(RandomSource var0) {
        return Util.shuffledCopy(this.validDirections, var0);
    }
}

