/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class PineFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<PineFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(var02 -> PineFoliagePlacer.foliagePlacerParts(var02).and((App)IntProvider.codec(0, 24).fieldOf("height").forGetter(var0 -> var0.height)).apply((Applicative)var02, PineFoliagePlacer::new));
    private final IntProvider height;

    public PineFoliagePlacer(IntProvider var0, IntProvider var1, IntProvider var2) {
        super(var0, var1);
        this.height = var2;
    }

    @Override
    protected FoliagePlacerType<?> type() {
        return FoliagePlacerType.PINE_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(LevelSimulatedReader var0, FoliagePlacer.FoliageSetter var1, RandomSource var2, TreeConfiguration var3, int var4, FoliagePlacer.FoliageAttachment var5, int var6, int var7, int var8) {
        int var9 = 0;
        for (int var10 = var8; var10 >= var8 - var6; --var10) {
            this.placeLeavesRow(var0, var1, var2, var3, var5.pos(), var9, var10, var5.doubleTrunk());
            if (var9 >= 1 && var10 == var8 - var6 + 1) {
                --var9;
                continue;
            }
            if (var9 >= var7 + var5.radiusOffset()) continue;
            ++var9;
        }
    }

    @Override
    public int foliageRadius(RandomSource var0, int var1) {
        return super.foliageRadius(var0, var1) + var0.nextInt(Math.max(var1 + 1, 1));
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, TreeConfiguration var2) {
        return this.height.sample(var0);
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        return var1 == var4 && var3 == var4 && var4 > 0;
    }
}

