/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.foliageplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;

public class SpruceFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<SpruceFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(var02 -> SpruceFoliagePlacer.foliagePlacerParts(var02).and((App)IntProvider.codec(0, 24).fieldOf("trunk_height").forGetter(var0 -> var0.trunkHeight)).apply((Applicative)var02, SpruceFoliagePlacer::new));
    private final IntProvider trunkHeight;

    public SpruceFoliagePlacer(IntProvider var0, IntProvider var1, IntProvider var2) {
        super(var0, var1);
        this.trunkHeight = var2;
    }

    @Override
    protected FoliagePlacerType<?> type() {
        return FoliagePlacerType.SPRUCE_FOLIAGE_PLACER;
    }

    @Override
    protected void createFoliage(LevelSimulatedReader var0, FoliagePlacer.FoliageSetter var1, RandomSource var2, TreeConfiguration var3, int var4, FoliagePlacer.FoliageAttachment var5, int var6, int var7, int var8) {
        BlockPos var9 = var5.pos();
        int var10 = var2.nextInt(2);
        int var11 = 1;
        int var12 = 0;
        for (int var13 = var8; var13 >= -var6; --var13) {
            this.placeLeavesRow(var0, var1, var2, var3, var9, var10, var13, var5.doubleTrunk());
            if (var10 >= var11) {
                var10 = var12;
                var12 = 1;
                var11 = Math.min(var11 + 1, var7 + var5.radiusOffset());
                continue;
            }
            ++var10;
        }
    }

    @Override
    public int foliageHeight(RandomSource var0, int var1, TreeConfiguration var2) {
        return Math.max(4, var1 - this.trunkHeight.sample(var0));
    }

    @Override
    protected boolean shouldSkipLocation(RandomSource var0, int var1, int var2, int var3, int var4, boolean var5) {
        return var1 == var4 && var3 == var4 && var4 > 0;
    }
}

