/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.rootplacers;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.rootplacers.AboveRootPlacement;
import net.minecraft.world.level.levelgen.feature.rootplacers.RootPlacerType;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public abstract class RootPlacer {
    public static final Codec<RootPlacer> CODEC = BuiltInRegistries.ROOT_PLACER_TYPE.byNameCodec().dispatch(RootPlacer::type, RootPlacerType::codec);
    protected final IntProvider trunkOffsetY;
    protected final BlockStateProvider rootProvider;
    protected final Optional<AboveRootPlacement> aboveRootPlacement;

    protected static <P extends RootPlacer> Products.P3<RecordCodecBuilder.Mu<P>, IntProvider, BlockStateProvider, Optional<AboveRootPlacement>> rootPlacerParts(RecordCodecBuilder.Instance<P> var02) {
        return var02.group((App)IntProvider.CODEC.fieldOf("trunk_offset_y").forGetter(var0 -> var0.trunkOffsetY), (App)BlockStateProvider.CODEC.fieldOf("root_provider").forGetter(var0 -> var0.rootProvider), (App)AboveRootPlacement.CODEC.optionalFieldOf("above_root_placement").forGetter(var0 -> var0.aboveRootPlacement));
    }

    public RootPlacer(IntProvider var0, BlockStateProvider var1, Optional<AboveRootPlacement> var2) {
        this.trunkOffsetY = var0;
        this.rootProvider = var1;
        this.aboveRootPlacement = var2;
    }

    protected abstract RootPlacerType<?> type();

    public abstract boolean placeRoots(LevelSimulatedReader var1, BiConsumer<BlockPos, BlockState> var2, RandomSource var3, BlockPos var4, BlockPos var5, TreeConfiguration var6);

    protected boolean canPlaceRoot(LevelSimulatedReader var0, BlockPos var1) {
        return TreeFeature.validTreePos(var0, var1);
    }

    protected void placeRoot(LevelSimulatedReader var0, BiConsumer<BlockPos, BlockState> var1, RandomSource var2, BlockPos var3, TreeConfiguration var4) {
        if (!this.canPlaceRoot(var0, var3)) {
            return;
        }
        var1.accept(var3, this.getPotentiallyWaterloggedState(var0, var3, this.rootProvider.getState(var2, var3)));
        if (this.aboveRootPlacement.isPresent()) {
            AboveRootPlacement var5 = this.aboveRootPlacement.get();
            BlockPos var6 = var3.above();
            if (var2.nextFloat() < var5.aboveRootPlacementChance() && var0.isStateAtPosition(var6, BlockBehaviour.BlockStateBase::isAir)) {
                var1.accept(var6, this.getPotentiallyWaterloggedState(var0, var6, var5.aboveRootProvider().getState(var2, var6)));
            }
        }
    }

    protected BlockState getPotentiallyWaterloggedState(LevelSimulatedReader var02, BlockPos var1, BlockState var2) {
        if (var2.hasProperty(BlockStateProperties.WATERLOGGED)) {
            boolean var3 = var02.isFluidAtPosition(var1, var0 -> var0.is(FluidTags.WATER));
            return (BlockState)var2.setValue(BlockStateProperties.WATERLOGGED, var3);
        }
        return var2;
    }

    public BlockPos getTrunkOrigin(BlockPos var0, RandomSource var1) {
        return var0.above(this.trunkOffsetY.sample(var1));
    }
}

