/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Util;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class AttachedToLogsDecorator
extends TreeDecorator {
    public static final MapCodec<AttachedToLogsDecorator> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability").forGetter(var0 -> Float.valueOf(var0.probability)), (App)BlockStateProvider.CODEC.fieldOf("block_provider").forGetter(var0 -> var0.blockProvider), (App)ExtraCodecs.nonEmptyList(Direction.CODEC.listOf()).fieldOf("directions").forGetter(var0 -> var0.directions)).apply((Applicative)var02, AttachedToLogsDecorator::new));
    private final float probability;
    private final BlockStateProvider blockProvider;
    private final List<Direction> directions;

    public AttachedToLogsDecorator(float var0, BlockStateProvider var1, List<Direction> var2) {
        this.probability = var0;
        this.blockProvider = var1;
        this.directions = var2;
    }

    @Override
    public void place(TreeDecorator.Context var0) {
        RandomSource var1 = var0.random();
        for (BlockPos var3 : Util.shuffledCopy(var0.logs(), var1)) {
            Direction var4 = Util.getRandom(this.directions, var1);
            BlockPos var5 = var3.relative(var4);
            if (!(var1.nextFloat() <= this.probability) || !var0.isAir(var5)) continue;
            var0.setBlock(var5, this.blockProvider.getState(var1, var5));
        }
    }

    @Override
    protected TreeDecoratorType<?> type() {
        return TreeDecoratorType.ATTACHED_TO_LOGS;
    }
}

